/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hbase;

import com.cloudera.sqoop.hbase.PutTransformer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;

public class ToStringPutTransformer
extends PutTransformer {
    public static final Log LOG = LogFactory.getLog((String)ToStringPutTransformer.class.getName());
    private Map<String, byte[]> serializedFieldNames = new TreeMap<String, byte[]>();
    protected boolean bigDecimalFormatString;
    protected boolean addRowKey;
    private boolean isCompositeKey = false;
    private List<String> compositeKeyAttributes;
    public static final String DELIMITER_COMMAND_LINE = ",";
    public static final String DELIMITER_HBASE = "_";

    private byte[] getFieldNameBytes(String fieldName) {
        byte[] cachedName = this.serializedFieldNames.get(fieldName);
        if (null != cachedName) {
            return cachedName;
        }
        byte[] nameBytes = Bytes.toBytes((String)fieldName);
        this.serializedFieldNames.put(fieldName, nameBytes);
        return nameBytes;
    }

    public void detectCompositeKey() {
        String rowKeyCol = this.getRowKeyColumn();
        if (null != rowKeyCol && rowKeyCol.contains(DELIMITER_COMMAND_LINE)) {
            this.isCompositeKey = true;
            String[] compositeKeyArray = rowKeyCol.split(DELIMITER_COMMAND_LINE);
            this.compositeKeyAttributes = Arrays.asList(compositeKeyArray);
        }
    }

    @Override
    public List<Mutation> getMutationCommand(Map<String, Object> fields) throws IOException {
        String rowKeyCol = this.getRowKeyColumn();
        if (null == rowKeyCol) {
            throw new IOException("Row key column can't be NULL.");
        }
        String colFamily = this.getColumnFamily();
        if (null == colFamily) {
            throw new IOException("Column family can't be NULL.");
        }
        if (this.isCompositeKey) {
            ArrayList<String> rowKeyList = new ArrayList<String>();
            for (String fieldName : this.compositeKeyAttributes) {
                Object fieldValue = fields.get(fieldName);
                if (null == fieldValue) {
                    throw new IOException("Could not insert row with null value for row-key column: " + fieldName);
                }
                String rowKey = this.toHBaseString(fieldValue);
                rowKeyList.add(rowKey);
            }
            String compositeRowKey = StringUtils.join((CharSequence)DELIMITER_HBASE, rowKeyList);
            return this.mutationRecordInHBase(fields, colFamily, compositeRowKey);
        }
        Object rowKey = fields.get(rowKeyCol);
        if (null == rowKey) {
            throw new IOException("Could not insert row with null value for row-key column: " + rowKeyCol);
        }
        String hBaseRowKey = this.toHBaseString(rowKey);
        return this.mutationRecordInHBase(fields, colFamily, hBaseRowKey);
    }

    private List<Mutation> mutationRecordInHBase(Map<String, Object> record, String colFamily, String rowKey) {
        byte[] colFamilyBytes = Bytes.toBytes((String)colFamily);
        ArrayList<Object> mutationList = new ArrayList<Object>();
        for (Map.Entry<String, Object> fieldEntry : record.entrySet()) {
            String colName = fieldEntry.getKey();
            boolean rowKeyCol = false;
            if (this.isCompositeKey && this.compositeKeyAttributes.contains(colName) || colName.equals(this.getRowKeyColumn())) {
                rowKeyCol = true;
            }
            if (rowKeyCol && !this.addRowKey) continue;
            Object val = fieldEntry.getValue();
            if (null != val) {
                Put put = new Put(Bytes.toBytes((String)rowKey));
                if (val instanceof byte[]) {
                    put.addColumn(colFamilyBytes, this.getFieldNameBytes(colName), (byte[])val);
                } else {
                    put.addColumn(colFamilyBytes, this.getFieldNameBytes(colName), Bytes.toBytes((String)this.toHBaseString(val)));
                }
                mutationList.add(put);
                continue;
            }
            Delete delete = new Delete(Bytes.toBytes((String)rowKey));
            delete.addColumn(colFamilyBytes, this.getFieldNameBytes(colName));
            mutationList.add(delete);
        }
        return Collections.unmodifiableList(mutationList);
    }

    private String toHBaseString(Object val) {
        String valString = val instanceof BigDecimal && this.bigDecimalFormatString ? ((BigDecimal)val).toPlainString() : val.toString();
        return valString;
    }

    @Override
    public void init(Configuration conf) {
        this.setColumnFamily(conf.get("sqoop.hbase.insert.column.family", null));
        this.setRowKeyColumn(conf.get("sqoop.hbase.insert.row.key.column", null));
        this.bigDecimalFormatString = conf.getBoolean("sqoop.bigdecimal.format.string", true);
        this.addRowKey = conf.getBoolean("sqoop.hbase.add.row.key", false);
        this.detectCompositeKey();
    }
}

