/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrasstableoutput.writer;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.pentaho.cassandra.util.CassandraUtils;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.cassandrasstableoutput.writer.AbstractSSTableWriter;

class CQL3SSTableWriter
extends AbstractSSTableWriter {
    private CQLSSTableWriter writer;
    private RowMetaInterface rowMeta;

    CQL3SSTableWriter() {
    }

    @Override
    public void init() throws Exception {
        this.purgeSchemaInstance();
        this.writer = this.getCQLSSTableWriter();
    }

    void purgeSchemaInstance() {
        CFMetaData cfm = CFMetaData.Builder.create((String)this.getKeyspace(), (String)this.getTable()).withPartitioner(CassandraUtils.getPartitionerClassInstance(this.getPartitionerClass())).addPartitionKey(this.getPartitionKey(), (AbstractType)UTF8Type.instance).build();
        Schema.instance.unload(cfm);
    }

    CQLSSTableWriter getCQLSSTableWriter() {
        return CQLSSTableWriter.builder().inDirectory(this.getDirectory()).forTable(this.buildCreateTableCQLStatement()).using(this.buildInsertCQLStatement()).withBufferSizeInMB(this.getBufferSize()).build();
    }

    @Override
    public void processRow(Map<String, Object> record) throws Exception {
        this.writer.addRow(record);
    }

    @Override
    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    String buildCreateTableCQLStatement() {
        StringBuilder tableColumnsSpecification = new StringBuilder();
        for (ValueMetaInterface valueMeta : this.rowMeta.getValueMetaList()) {
            tableColumnsSpecification.append(CassandraUtils.cql3MixedCaseQuote(valueMeta.getName())).append(" ").append(CassandraUtils.getCQLTypeForValueMeta(valueMeta)).append(",");
        }
        tableColumnsSpecification.append("PRIMARY KEY (\"").append(this.getPrimaryKey().replaceAll(",", "\",\"")).append("\" )");
        return String.format("CREATE TABLE %s.%s (%s);", this.getKeyspace(), this.getTable(), tableColumnsSpecification);
    }

    String buildInsertCQLStatement() {
        Joiner columnsJoiner = Joiner.on((String)"\",\"").skipNulls();
        Joiner valuesJoiner = Joiner.on((String)",").skipNulls();
        Object[] columnNames = this.rowMeta.getFieldNames();
        Object[] valuePlaceholders = new String[columnNames.length];
        Arrays.fill(valuePlaceholders, "?");
        return String.format("INSERT INTO %s.%s (\"%s\") VALUES (%s);", this.getKeyspace(), this.getTable(), columnsJoiner.join(columnNames), valuesJoiner.join(valuePlaceholders));
    }
}

