/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.ReadStatistics;
import org.apache.hadoop.hdfs.ReaderStrategy;
import org.apache.hadoop.hdfs.util.IOUtilsClient;

class ByteArrayStrategy
implements ReaderStrategy {
    private final DFSClient dfsClient;
    private final ReadStatistics readStatistics;
    private final byte[] readBuf;
    private int offset;
    private final int targetLength;

    public ByteArrayStrategy(byte[] readBuf, int offset, int targetLength, ReadStatistics readStatistics, DFSClient dfsClient) {
        this.readBuf = readBuf;
        this.offset = offset;
        this.targetLength = targetLength;
        this.readStatistics = readStatistics;
        this.dfsClient = dfsClient;
    }

    @Override
    public ByteBuffer getReadBuffer() {
        return ByteBuffer.wrap(this.readBuf, this.offset, this.targetLength);
    }

    @Override
    public int getTargetLength() {
        return this.targetLength;
    }

    @Override
    public int readFromBlock(BlockReader blockReader) throws IOException {
        return this.readFromBlock(blockReader, this.targetLength);
    }

    @Override
    public int readFromBlock(BlockReader blockReader, int length) throws IOException {
        int nRead = blockReader.read(this.readBuf, this.offset, length);
        if (nRead > 0) {
            IOUtilsClient.updateReadStatistics(this.readStatistics, nRead, blockReader);
            this.dfsClient.updateFileSystemReadStats(blockReader.getNetworkDistance(), nRead);
            this.offset += nRead;
        }
        return nRead;
    }

    @Override
    public int readFromBuffer(ByteBuffer src) {
        return this.readFromBuffer(src, src.remaining());
    }

    @Override
    public int readFromBuffer(ByteBuffer src, int length) {
        ByteBuffer dup = src.duplicate();
        dup.get(this.readBuf, this.offset, length);
        this.offset += length;
        return length;
    }
}

