/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.reactivex.Observer;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.HttpClientUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.dataservice.client.ConnectionAbortingSupport;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.jdbc.ThinConnection;
import org.pentaho.di.trans.dataservice.jdbc.ThinServiceInformation;
import org.pentaho.di.trans.dataservice.jdbc.api.IThinServiceInformation;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class RemoteClient
implements IDataServiceClientService,
ConnectionAbortingSupport {
    private static final String SQL = "SQL";
    private static final String MAX_ROWS = "MaxRows";
    private static final String WINDOW_MODE = "WindowMode";
    private static final String WINDOW_SIZE = "WindowSize";
    private static final String WINDOW_EVERY = "WindowEvery";
    private static final String WINDOW_LIMIT = "WindowLimit";
    private static final String CONTENT_CHARSET = "utf-8";
    private static final int MAX_SQL_LENGTH = 7500;
    private final ThinConnection connection;
    private final HttpClient client;
    private final HttpClientContext context;
    private DocumentBuilderFactory docBuilderFactory;
    private static final String SERVICE_PATH = "/sql/";
    private final CopyOnWriteArrayList<HttpPost> activeMethods = new CopyOnWriteArrayList();

    RemoteClient(ThinConnection connection, HttpClient client, HttpClientContext context) {
        this.connection = connection;
        this.client = client;
        this.context = context;
    }

    public DataInputStream query(String sql, int maxRows) throws SQLException {
        return this.query(sql, maxRows, null);
    }

    public DataInputStream query(String sql, int maxRows, Map<String, String> params) throws SQLException {
        DataInputStream dataInputStream;
        HttpPost method = null;
        try {
            String url = this.connection.constructUrl(SERVICE_PATH);
            method = new HttpPost(url);
            method.getParams().setParameter("http.socket.timeout", (Object)0);
            String windowMode = this.connection.getWindowMode();
            String windowSize = this.connection.getWindowSize();
            String windowEvery = this.connection.getWindowEvery();
            String windowLimit = this.connection.getWindowLimit();
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            if (sql.length() < 7500) {
                method.addHeader((Header)new BasicHeader(SQL, CharMatcher.anyOf((CharSequence)"\n\r").collapseFrom((CharSequence)sql, ' ')));
                method.addHeader((Header)new BasicHeader(MAX_ROWS, Integer.toString(maxRows)));
                if (!Strings.isNullOrEmpty((String)windowMode)) {
                    method.addHeader((Header)new BasicHeader(WINDOW_MODE, windowMode));
                }
                if (!Strings.isNullOrEmpty((String)windowSize)) {
                    method.addHeader((Header)new BasicHeader(WINDOW_SIZE, windowSize));
                }
                if (!Strings.isNullOrEmpty((String)windowEvery)) {
                    method.addHeader((Header)new BasicHeader(WINDOW_EVERY, windowEvery));
                }
                if (!Strings.isNullOrEmpty((String)windowLimit)) {
                    method.addHeader((Header)new BasicHeader(WINDOW_LIMIT, windowLimit));
                }
            }
            for (Map.Entry parameterEntry : this.connection.getParameters().entrySet()) {
                postParameters.add(new BasicNameValuePair((String)parameterEntry.getKey(), (String)parameterEntry.getValue()));
            }
            postParameters.add(new BasicNameValuePair(SQL, CharMatcher.anyOf((CharSequence)"\n\r").collapseFrom((CharSequence)sql, ' ')));
            postParameters.add(new BasicNameValuePair(MAX_ROWS, Integer.toString(maxRows)));
            if (!Strings.isNullOrEmpty((String)windowMode)) {
                postParameters.add(new BasicNameValuePair(WINDOW_MODE, windowMode));
            }
            if (!Strings.isNullOrEmpty((String)windowSize)) {
                postParameters.add(new BasicNameValuePair(WINDOW_SIZE, windowSize));
            }
            if (!Strings.isNullOrEmpty((String)windowEvery)) {
                postParameters.add(new BasicNameValuePair(WINDOW_EVERY, windowEvery));
            }
            if (!Strings.isNullOrEmpty((String)windowLimit)) {
                postParameters.add(new BasicNameValuePair(WINDOW_LIMIT, windowLimit));
            }
            if (!Strings.isNullOrEmpty((String)this.connection.getDebugTransFilename())) {
                postParameters.add(new BasicNameValuePair("debugtrans", this.connection.getDebugTransFilename()));
            }
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, CONTENT_CHARSET));
            this.activeMethods.add(method);
            HttpResponse httpResponse = this.execMethod((HttpRequestBase)method);
            dataInputStream = new DataInputStream(HttpClientUtil.responseToInputStream((HttpResponse)httpResponse));
            this.activeMethods.remove(method);
        }
        catch (Exception e) {
            try {
                throw RemoteClient.serverException(e);
            }
            catch (Throwable throwable) {
                this.activeMethods.remove(method);
                throw throwable;
            }
        }
        return dataInputStream;
    }

    public DataInputStream query(String sql, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit) throws SQLException {
        return this.query(sql, windowMode, windowSize, windowEvery, windowLimit, null);
    }

    public DataInputStream query(String sql, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit, Map<String, String> params) throws SQLException {
        DataInputStream dataInputStream;
        HttpPost method = null;
        try {
            String url = this.connection.constructUrl(SERVICE_PATH);
            method = new HttpPost(url);
            method.getParams().setParameter("http.socket.timeout", (Object)0);
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            if (sql.length() < 7500) {
                method.addHeader((Header)new BasicHeader(SQL, CharMatcher.anyOf((CharSequence)"\n\r").collapseFrom((CharSequence)sql, ' ')));
                method.addHeader((Header)new BasicHeader(WINDOW_MODE, windowMode.toString()));
                method.addHeader((Header)new BasicHeader(WINDOW_SIZE, Long.toString(windowSize)));
                method.addHeader((Header)new BasicHeader(WINDOW_EVERY, Long.toString(windowEvery)));
                method.addHeader((Header)new BasicHeader(WINDOW_LIMIT, Long.toString(windowLimit)));
            }
            for (Map.Entry parameterEntry : this.connection.getParameters().entrySet()) {
                postParameters.add(new BasicNameValuePair((String)parameterEntry.getKey(), (String)parameterEntry.getValue()));
            }
            postParameters.add(new BasicNameValuePair(SQL, CharMatcher.anyOf((CharSequence)"\n\r").collapseFrom((CharSequence)sql, ' ')));
            postParameters.add(new BasicNameValuePair(WINDOW_MODE, windowMode.toString()));
            postParameters.add(new BasicNameValuePair(WINDOW_SIZE, Long.toString(windowSize)));
            postParameters.add(new BasicNameValuePair(WINDOW_EVERY, Long.toString(windowEvery)));
            postParameters.add(new BasicNameValuePair(WINDOW_LIMIT, Long.toString(windowLimit)));
            if (!Strings.isNullOrEmpty((String)this.connection.getDebugTransFilename())) {
                postParameters.add(new BasicNameValuePair("debugtrans", this.connection.getDebugTransFilename()));
            }
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, CONTENT_CHARSET));
            this.activeMethods.add(method);
            HttpResponse httpResponse = this.execMethod((HttpRequestBase)method);
            dataInputStream = new DataInputStream(HttpClientUtil.responseToInputStream((HttpResponse)httpResponse));
            this.activeMethods.remove(method);
        }
        catch (Exception e) {
            try {
                throw RemoteClient.serverException(e);
            }
            catch (Throwable throwable) {
                this.activeMethods.remove(method);
                throw throwable;
            }
        }
        return dataInputStream;
    }

    public List<IThinServiceInformation> getServiceInformation() throws SQLException {
        ArrayList services = Lists.newArrayList();
        try {
            String result = this.execService("/listServices");
            Document doc = XMLHandler.loadXMLString((DocumentBuilder)this.createDocumentBuilder(), (String)result);
            Node servicesNode = XMLHandler.getSubNode((Node)doc, (String)"services");
            List serviceNodes = XMLHandler.getNodes((Node)servicesNode, (String)"service");
            for (Node serviceNode : serviceNodes) {
                String name = XMLHandler.getTagValue((Node)serviceNode, (String)"name");
                boolean streaming = XMLHandler.getTagValue((Node)serviceNode, (String)"streaming").equals("Y");
                Node rowMetaNode = XMLHandler.getSubNode((Node)serviceNode, (String)"row-meta");
                RowMeta serviceFields = new RowMeta(rowMetaNode);
                ThinServiceInformation service = new ThinServiceInformation(name, streaming, (RowMetaInterface)serviceFields);
                services.add(service);
            }
        }
        catch (Exception e) {
            throw RemoteClient.serverException(e);
        }
        return services;
    }

    public ThinServiceInformation getServiceInformation(String name) throws SQLException {
        try {
            List<Node> serviceNodes = this.getServiceNodes(name);
            for (Node serviceNode : serviceNodes) {
                String serviceName = XMLHandler.getTagValue((Node)serviceNode, (String)"name");
                boolean streaming = XMLHandler.getTagValue((Node)serviceNode, (String)"streaming").equals("Y");
                if (!serviceName.equals(name)) continue;
                Node rowMetaNode = XMLHandler.getSubNode((Node)serviceNode, (String)"row-meta");
                RowMeta serviceFields = new RowMeta(rowMetaNode);
                return new ThinServiceInformation(serviceName, streaming, (RowMetaInterface)serviceFields);
            }
        }
        catch (Exception e) {
            throw RemoteClient.serverException(e);
        }
        return null;
    }

    public List<String> getServiceNames() throws SQLException {
        return this.getServiceNames(null);
    }

    public List<String> getServiceNames(String serviceName) throws SQLException {
        return this.getServices(serviceName);
    }

    private List<String> getServices(String serviceName) throws SQLException {
        ArrayList<String> serviceNames = new ArrayList<String>();
        try {
            List<Node> serviceNodes = this.getServiceNodes(serviceName);
            for (Node serviceNode : serviceNodes) {
                serviceNames.add(XMLHandler.getTagValue((Node)serviceNode, (String)"name"));
            }
        }
        catch (Exception e) {
            throw RemoteClient.serverException(e);
        }
        return serviceNames;
    }

    private List<Node> getServiceNodes(String name) throws Exception {
        StringBuilder serviceArguments = new StringBuilder().append("/listServices");
        if (StringUtils.isNotBlank((String)name)) {
            serviceArguments.append("?serviceName=");
            serviceArguments.append(URLEncoder.encode(name, CONTENT_CHARSET));
        }
        String result = this.execService(serviceArguments.toString());
        Document doc = XMLHandler.loadXMLString((DocumentBuilder)this.createDocumentBuilder(), (String)result);
        Node servicesNode = XMLHandler.getSubNode((Node)doc, (String)"services");
        return XMLHandler.getNodes((Node)servicesNode, (String)"service");
    }

    @Override
    public void disconnect() {
        for (HttpPost method : this.activeMethods) {
            method.abort();
        }
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.docBuilderFactory == null) {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return this.docBuilderFactory.newDocumentBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String execService(String serviceAndArguments) throws SQLException {
        String string;
        String urlString = this.connection.constructUrl(serviceAndArguments);
        HttpGet method = new HttpGet(urlString);
        try {
            HttpResponse httpResponse = this.execMethod((HttpRequestBase)method);
            string = this.httpResponseToString(httpResponse);
        }
        catch (Throwable throwable) {
            try {
                method.releaseConnection();
                throw throwable;
            }
            catch (Exception e) {
                throw RemoteClient.serverException(e);
            }
        }
        method.releaseConnection();
        return string;
    }

    HttpResponse execMethod(HttpRequestBase method) throws SQLException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.context != null ? this.client.execute((HttpUriRequest)method, (HttpContext)this.context) : this.client.execute((HttpUriRequest)method);
            int result = httpResponse.getStatusLine().getStatusCode();
            if (result == 500) {
                throw new SQLException("There was an error reading data from the server.");
            }
            if (result == 401) {
                throw new SQLException("Nice try-but we couldn't log you in. Check your username and password and try again.");
            }
            if (result != 200) {
                throw new SQLException(this.httpResponseToString(httpResponse));
            }
        }
        catch (IOException e) {
            throw new SQLException("You don't seem to be getting a connection to the server or you have closed it. Check the host and port you're using and make sure the sever is up and running.");
        }
        return httpResponse;
    }

    protected String httpResponseToString(HttpResponse httpResponse) throws IOException {
        return HttpClientUtil.responseToString((HttpResponse)httpResponse);
    }

    private static SQLException serverException(Exception e) throws SQLException {
        Throwables.propagateIfPossible((Throwable)e, SQLException.class);
        throw new SQLException("Error connecting to server", e);
    }

    @Deprecated
    public void setRepository(Repository repository) {
    }

    @Deprecated
    public void setMetaStore(IMetaStore metaStore) {
    }

    public void query(String sql, IDataServiceClientService.IStreamingParams streamParams, Map<String, String> params, Observer<List<RowMetaAndData>> consumer) throws Exception {
        throw new UnsupportedOperationException("Only available in local mode.");
    }
}

