/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.command;

import org.apache.karaf.instance.command.InstanceCommandSupport;
import org.apache.karaf.instance.core.InstanceSettings;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;

@Command(scope="instance", name="clone", description="Clones an existing container instance.")
public class CloneCommand
extends InstanceCommandSupport {
    @Option(name="-s", aliases={"--ssh-port"}, description="Port number for remote secure shell connection", required=false, multiValued=false)
    int sshPort = 0;
    @Option(name="-r", aliases={"-rr", "--rmi-port", "--rmi-registry-port"}, description="Port number for RMI registry connection", required=false, multiValued=false)
    int rmiRegistryPort = 0;
    @Option(name="-rs", aliases={"--rmi-server-port"}, description="Port number for RMI server connection", required=false, multiValued=false)
    int rmiServerPort = 0;
    @Option(name="-l", aliases={"--location"}, description="Location of the cloned container instance in the file system", required=false, multiValued=false)
    String location;
    @Option(name="-o", aliases={"--java-opts"}, description="JVM options to use when launching the cloned instance", required=false, multiValued=false)
    String javaOpts;
    @Option(name="-v", aliases={"--verbose"}, description="Display actions performed by the command (disabled by default)", required=false, multiValued=false)
    boolean verbose = false;
    @Argument(index=0, name="name", description="The name of the source container instance", required=true, multiValued=false)
    String name;
    @Argument(index=1, name="cloneName", description="The name of the cloned container instance", required=true, multiValued=false)
    String cloneName;

    protected Object doExecute() throws Exception {
        InstanceSettings settings = new InstanceSettings(this.sshPort, this.rmiRegistryPort, this.rmiServerPort, this.location, this.javaOpts, null, null);
        this.getInstanceService().cloneInstance(this.name, this.cloneName, settings, this.verbose);
        return null;
    }
}

