/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.runtime.api.impl.TaskSpec;

public class SubmitWorkInfo
implements Writable {
    private TaskSpec taskSpec;
    private ApplicationId fakeAppId;
    private long creationTime;
    private Token<JobTokenIdentifier> token;

    public SubmitWorkInfo(TaskSpec taskSpec, ApplicationId fakeAppId, long creationTime) {
        this.taskSpec = taskSpec;
        this.fakeAppId = fakeAppId;
        this.token = this.createJobToken();
        this.creationTime = creationTime;
    }

    public SubmitWorkInfo() {
    }

    public TaskSpec getTaskSpec() {
        return this.taskSpec;
    }

    public ApplicationId getFakeAppId() {
        return this.fakeAppId;
    }

    public String getTokenIdentifier() {
        return this.fakeAppId.toString();
    }

    public Token<JobTokenIdentifier> getToken() {
        return this.token;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void write(DataOutput out) throws IOException {
        this.taskSpec.write(out);
        out.writeLong(this.fakeAppId.getClusterTimestamp());
        out.writeInt(this.fakeAppId.getId());
        this.token.write(out);
        out.writeLong(this.creationTime);
    }

    public void readFields(DataInput in) throws IOException {
        this.taskSpec = new TaskSpec();
        this.taskSpec.readFields(in);
        long appIdTs = in.readLong();
        int appIdId = in.readInt();
        this.fakeAppId = ApplicationId.newInstance((long)appIdTs, (int)appIdId);
        this.token = new Token();
        this.token.readFields(in);
        this.creationTime = in.readLong();
    }

    public static byte[] toBytes(SubmitWorkInfo submitWorkInfo) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        submitWorkInfo.write((DataOutput)dob);
        return dob.getData();
    }

    public static SubmitWorkInfo fromBytes(byte[] submitWorkInfoBytes) throws IOException {
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(submitWorkInfoBytes, 0, submitWorkInfoBytes.length);
        SubmitWorkInfo submitWorkInfo = new SubmitWorkInfo();
        submitWorkInfo.readFields((DataInput)dib);
        return submitWorkInfo;
    }

    private Token<JobTokenIdentifier> createJobToken() {
        String tokenIdentifier = this.fakeAppId.toString();
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(tokenIdentifier));
        Token sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)new JobTokenSecretManager());
        sessionToken.setService(identifier.getJobId());
        return sessionToken;
    }
}

