/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.AuthorizationException;
import org.apache.oozie.service.AuthorizationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.BaseJobServlet;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.JobsFilterUtils;
import org.apache.oozie.util.XConfiguration;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public abstract class BaseJobsServlet
extends JsonRestServlet {
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];

    public BaseJobsServlet(String instrumentationName) {
        super(instrumentationName, RESOURCES_INFO);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.validateContentType(request, "application/xml");
        request.setAttribute("audit.operation", (Object)request.getParameter("action"));
        XConfiguration conf = new XConfiguration((InputStream)request.getInputStream());
        this.stopCron();
        conf = conf.trim();
        conf = conf.resolve();
        BaseJobsServlet.validateJobConfiguration(conf);
        String requestUser = this.getUser(request);
        if (!requestUser.equals("?")) {
            conf.set("user.name", requestUser);
        }
        BaseJobServlet.checkAuthorizationForApp(conf);
        JobUtils.normalizeAppPath(conf.get("user.name"), conf.get("group.name"), conf);
        JSONObject json = this.submitJob(request, conf);
        this.startCron();
        this.sendJsonResponse(response, 201, (JSONStreamAware)json);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String externalId = request.getParameter("external-id");
        if (externalId != null) {
            this.stopCron();
            JSONObject json = this.getJobIdForExternalId(request, externalId);
            this.startCron();
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else {
            this.stopCron();
            JSONObject json = this.getJobs(request);
            this.startCron();
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("audit.param", (Object)request.getParameter("filter"));
        request.setAttribute("audit.operation", (Object)request.getParameter("action"));
        try {
            AuthorizationService auth = Services.get().get(AuthorizationService.class);
            String filter = request.getParameter("filter");
            String startStr = request.getParameter("offset");
            String lenStr = request.getParameter("len");
            String jobType = request.getParameter("jobtype");
            if (filter == null) {
                throw new IllegalArgumentException("filter params must be specified for bulk write API");
            }
            int start = startStr != null ? Integer.parseInt(startStr) : 1;
            start = start < 1 ? 1 : start;
            int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
            len = len < 1 ? 50 : len;
            auth.authorizeForJobs(this.getUser(request), JobsFilterUtils.parseFilter(filter), jobType, start, len, true);
        }
        catch (AuthorizationException ex) {
            throw new XServletException(401, ex);
        }
        String action = request.getParameter("action");
        JSONObject json = null;
        if (action.equals("kill")) {
            this.stopCron();
            json = this.killJobs(request, response);
            this.startCron();
        } else if (action.equals("resume")) {
            this.stopCron();
            json = this.resumeJobs(request, response);
            this.startCron();
        } else if (action.equals("suspend")) {
            this.stopCron();
            json = this.suspendJobs(request, response);
            this.startCron();
        } else {
            throw new XServletException(400, ErrorCode.E0303, "action", action);
        }
        response.setStatus(200);
        this.sendJsonResponse(response, 200, (JSONStreamAware)json);
    }

    abstract JSONObject killJobs(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract JSONObject suspendJobs(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract JSONObject resumeJobs(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract JSONObject submitJob(HttpServletRequest var1, Configuration var2) throws XServletException, IOException;

    abstract JSONObject getJobIdForExternalId(HttpServletRequest var1, String var2) throws XServletException, IOException;

    abstract JSONObject getJobs(HttpServletRequest var1) throws XServletException, IOException;

    static void validateJobConfiguration(Configuration conf) throws XServletException {
        if (conf.get("user.name") == null) {
            throw new XServletException(400, ErrorCode.E0401, "user.name");
        }
    }

    static {
        BaseJobsServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("", Arrays.asList("POST", "GET", "PUT"), Arrays.asList(new JsonRestServlet.ParameterInfo("action", String.class, false, Arrays.asList("POST", "PUT")), new JsonRestServlet.ParameterInfo("filter", String.class, false, Arrays.asList("GET", "PUT")), new JsonRestServlet.ParameterInfo("jobtype", String.class, false, Arrays.asList("GET", "POST", "PUT")), new JsonRestServlet.ParameterInfo("offset", String.class, false, Arrays.asList("GET", "PUT")), new JsonRestServlet.ParameterInfo("len", String.class, false, Arrays.asList("GET", "PUT")), new JsonRestServlet.ParameterInfo("bulk", String.class, false, Arrays.asList("GET", "PUT")), new JsonRestServlet.ParameterInfo("external-id", String.class, false, Arrays.asList("GET"))));
    }
}

