/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import org.apache.commons.lang.StringUtils;

public class CoordInputLogicEvaluatorResult {
    private STATUS status;
    private String dataSets;

    public CoordInputLogicEvaluatorResult() {
    }

    public CoordInputLogicEvaluatorResult(STATUS status, String dataSets) {
        this.status = status;
        this.dataSets = dataSets;
    }

    public CoordInputLogicEvaluatorResult(STATUS status) {
        this.status = status;
    }

    public String getDataSets() {
        return this.dataSets;
    }

    public void setDataSets(String dataSets) {
        this.dataSets = dataSets;
    }

    public void appendDataSets(String inputDataSets) {
        if (StringUtils.isEmpty((String)inputDataSets)) {
            return;
        }
        this.dataSets = StringUtils.isEmpty((String)this.dataSets) ? inputDataSets : this.dataSets + "," + inputDataSets;
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public boolean isTrue() {
        if (this.status == null) {
            return false;
        }
        switch (this.status) {
            case TIMED_WAITING: 
            case PHASE_TWO_EVALUATION: 
            case TRUE: {
                return true;
            }
        }
        return false;
    }

    public boolean isWaiting() {
        if (this.status == null) {
            return false;
        }
        return this.status.equals((Object)STATUS.TIMED_WAITING);
    }

    public boolean isPhaseTwoEvaluation() {
        if (this.status == null) {
            return false;
        }
        return this.status.equals((Object)STATUS.PHASE_TWO_EVALUATION);
    }

    public static enum STATUS {
        TRUE,
        FALSE,
        PHASE_TWO_EVALUATION,
        TIMED_WAITING;

    }
}

