/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.SubmitHttpXCommand;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class SubmitMRXCommand
extends SubmitHttpXCommand {
    private static final Set<String> SKIPPED_CONFS = new HashSet<String>();
    private static final Map<String, String> DEPRECATE_MAP = new HashMap<String, String>();

    public SubmitMRXCommand(Configuration conf) {
        super("submitMR", "submitMR", conf);
    }

    @Override
    protected Namespace getSectionNamespace() {
        return Namespace.getNamespace((String)"uri:oozie:workflow:0.2");
    }

    @Override
    protected String getWorkflowName() {
        return "mapreduce";
    }

    private Element generateConfigurationSection(Configuration conf, Namespace ns) {
        Element configuration = null;
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (MANDATORY_OOZIE_CONFS.contains(name) || OPTIONAL_OOZIE_CONFS.contains(name) || SKIPPED_CONFS.contains(name) || DEPRECATE_MAP.containsValue(name)) continue;
            if (configuration == null) {
                configuration = new Element("configuration", ns);
            }
            String value = (String)entry.getValue();
            Element property = new Element("property", ns);
            Element nameElement = new Element("name", ns);
            nameElement.addContent(name != null ? name : "");
            property.addContent((Content)nameElement);
            Element valueElement = new Element("value", ns);
            valueElement.addContent(value != null ? value : "");
            property.addContent((Content)valueElement);
            configuration.addContent((Content)property);
        }
        return configuration;
    }

    @Override
    protected Element generateSection(Configuration conf, Namespace ns) {
        Element mapreduce = new Element("map-reduce", ns);
        Element jt = new Element("job-tracker", ns);
        String newJTVal = conf.get(DEPRECATE_MAP.get("mapred.job.tracker"));
        jt.addContent(newJTVal != null ? newJTVal : conf.get("mapred.job.tracker"));
        mapreduce.addContent((Content)jt);
        Element nn = new Element("name-node", ns);
        String newNNVal = conf.get(DEPRECATE_MAP.get("fs.default.name"));
        nn.addContent(newNNVal != null ? newNNVal : conf.get("fs.default.name"));
        mapreduce.addContent((Content)nn);
        if (conf.size() > MANDATORY_OOZIE_CONFS.size()) {
            Element configuration = this.generateConfigurationSection(conf, ns);
            if (configuration != null) {
                mapreduce.addContent((Content)configuration);
            }
            SubmitMRXCommand.addFileSection(mapreduce, conf, ns);
            SubmitMRXCommand.addArchiveSection(mapreduce, conf, ns);
        }
        return mapreduce;
    }

    @Override
    protected void checkMandatoryConf(Configuration conf) {
        for (String key : MANDATORY_OOZIE_CONFS) {
            String value = conf.get(key);
            if (value != null) continue;
            if (DEPRECATE_MAP.containsKey(key)) {
                if (conf.get(DEPRECATE_MAP.get(key)) != null) continue;
                throw new RuntimeException(key + " or " + DEPRECATE_MAP.get(key) + " is not specified");
            }
            throw new RuntimeException(key + " is not specified");
        }
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() {
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
    }

    static {
        SKIPPED_CONFS.add("user.name");
        SKIPPED_CONFS.add("mapred.job.tracker");
        SKIPPED_CONFS.add("fs.default.name");
        DEPRECATE_MAP.put("fs.default.name", "fs.defaultFS");
        DEPRECATE_MAP.put("mapred.job.tracker", "mapreduce.jobtracker.address");
        DEPRECATE_MAP.put("user.name", "mapreduce.job.user.name");
    }
}

