/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.streaming.common.BaseStreamStep;
import org.pentaho.di.trans.streaming.common.BlockingQueueStreamSource;

public class JmsStreamSource
extends BlockingQueueStreamSource<List<Object>> {
    private final JmsDelegate jmsDelegate;
    private final int receiverTimeout;
    private JMSConsumer consumer;
    private AtomicBoolean closed = new AtomicBoolean(false);

    JmsStreamSource(BaseStreamStep streamStep, JmsDelegate jmsDelegate, int receiverTimeout) {
        super(streamStep);
        this.jmsDelegate = jmsDelegate;
        this.receiverTimeout = receiverTimeout;
    }

    public void open() {
        this.consumer = this.jmsDelegate.getJmsContext().createConsumer(this.jmsDelegate.getDestination());
        Executors.newSingleThreadExecutor().submit(this::receiveLoop);
    }

    private void receiveLoop() {
        try {
            Message message;
            while (!this.closed.get() && (message = this.consumer.receive((long)this.receiverTimeout)) != null) {
                this.streamStep.logDebug(message.toString());
                this.acceptRows(Collections.singletonList(Arrays.asList(message.getBody(Object.class), this.jmsDelegate.destinationName)));
            }
        }
        catch (JMSException | JMSRuntimeException jmsException) {
            this.error(jmsException);
        }
        finally {
            super.close();
            if (!this.closed.get()) {
                this.close();
                this.streamStep.logBasic(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsStreamSource.HitReceiveTimeout", (String[])new String[0]));
            }
        }
    }

    public void close() {
        if (this.consumer != null && !this.closed.getAndSet(true)) {
            this.consumer.close();
            this.jmsDelegate.getJmsContext().close();
        }
    }
}

