/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSContext;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.util.serialization.Sensitive;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.context.JmsProvider;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.Metaverse;

public class JmsDelegate {
    @Metaverse.Node(name="JMS Destination", type="JMS Destination", link="writesto", linkDirection="IN")
    @Injection(name="DESTINATION")
    public String destinationName = "";
    @Metaverse.Property(name="IBMMQ Url", parentNodeName="JMS Server")
    @Injection(name="IBMMQ_URL")
    public String ibmUrl = "";
    @Metaverse.Property(name="IBMMQ Username", parentNodeName="JMS Server")
    @Injection(name="IBMMQ_USERNAME")
    public String ibmUsername = "";
    @Sensitive
    @Injection(name="IBMMQ_PASSWORD")
    public String ibmPassword = "";
    @Metaverse.Property(name="AMQ Url", parentNodeName="JMS Server")
    @Injection(name="AMQ_URL")
    public String amqUrl = "";
    @Metaverse.Property(name="AMQ Username", parentNodeName="JMS Server")
    @Injection(name="AMQ_USERNAME")
    public String amqUsername = "";
    @Sensitive
    @Injection(name="AMQ_PASSWORD")
    public String amqPassword = "";
    @Metaverse.Node(name="JMS Server", type="JMS Server")
    @Metaverse.Property(name="JMS Server", parentNodeName="JMS Server")
    @Injection(name="CONNECTION_TYPE")
    public String connectionType = JmsProvider.ConnectionType.ACTIVEMQ.name();
    @Metaverse.Property(name="Destination Type", parentNodeName="JMS Destination")
    @Injection(name="DESTINATION_TYPE")
    public String destinationType = JmsProvider.DestinationType.QUEUE.name();
    @Injection(name="SSL_ENABLED", group="SSL_GROUP")
    public boolean sslEnabled = false;
    @Injection(name="SSL_KEYSTORE_PATH", group="SSL_GROUP")
    public String sslKeystorePath = "";
    @Injection(name="SSL_KEYSTORE_TYPE", group="SSL_GROUP")
    public String sslKeystoreType = "";
    @Sensitive
    @Injection(name="SSL_KEYSTORE_PASSWORD", group="SSL_GROUP")
    public String sslKeystorePassword = "";
    @Injection(name="SSL_TRUSTSTORE_PATH", group="SSL_GROUP")
    public String sslTruststorePath = "";
    @Injection(name="SSL_TRUSTSTORE_TYPE", group="SSL_GROUP")
    public String sslTruststoreType = "";
    @Sensitive
    @Injection(name="SSL_TRUSTSTORE_PASSWORD", group="SSL_GROUP")
    public String sslTruststorePassword = "";
    @Injection(name="SSL_CONTEXT_ALGORITHM", group="SSL_GROUP")
    public String sslContextAlgorithm = "";
    @Injection(name="SSL_CIPHERSUITE", group="SSL_GROUP")
    public String sslCipherSuite = "";
    @Injection(name="IBM_SSL_FIPSREQUIRED", group="SSL_GROUP")
    public String ibmSslFipsRequired = "";
    @Injection(name="AMQ_SSL_PROVIDER", group="SSL_GROUP")
    public String amqSslProvider = "";
    @Injection(name="AMQ_SSL_VERIFY_HOST", group="SSL_GROUP")
    public String amqSslVerifyHost = "";
    @Injection(name="AMQ_SSL_TRUST_ALL", group="SSL_GROUP")
    public String amqSslTrustAll = "";
    @Injection(name="SSL_USE_DEFAULT_CONTEXT", group="SSL_GROUP")
    public boolean sslUseDefaultContext = false;
    List<JmsProvider> jmsProviders;

    public JmsDelegate(List<JmsProvider> jmsProviders) {
        this.jmsProviders = jmsProviders;
    }

    Destination getDestination() {
        return this.getJmsProvider().getDestination(this);
    }

    JMSContext getJmsContext() {
        return this.getJmsProvider().getContext(this);
    }

    JmsProvider getJmsProvider() {
        return this.jmsProviders.stream().filter(prov -> prov.supports(JmsProvider.ConnectionType.valueOf(this.connectionType))).findFirst().orElseThrow(() -> new RuntimeException(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDelegate.UnsupportedConnectionType", (String[])new String[0])));
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getConnectionUrl() {
        return this.connectionType.equals(JmsProvider.ConnectionType.ACTIVEMQ.name()) ? this.amqUrl : this.ibmUrl;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getDestinationType() {
        return this.destinationType;
    }
}

