/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import java.util.Objects;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsConsumerMeta;
import org.pentaho.di.trans.step.jms.JmsStreamSource;
import org.pentaho.di.trans.streaming.common.BaseStreamStep;
import org.pentaho.di.trans.streaming.common.FixedTimeStreamWindow;

public class JmsConsumer
extends BaseStreamStep {
    public JmsConsumer(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        boolean superStatus = super.init(stepMetaInterface, stepDataInterface);
        JmsConsumerMeta jmsConsumerMeta = (JmsConsumerMeta)this.variablizedStepMeta;
        if (!this.validateParams(jmsConsumerMeta)) {
            return false;
        }
        this.log.logDebug("Connection Details: " + jmsConsumerMeta.jmsDelegate.getJmsProvider().getConnectionDetails(jmsConsumerMeta.jmsDelegate));
        this.window = new FixedTimeStreamWindow(this.subtransExecutor, jmsConsumerMeta.getRowMeta(), this.getDuration(), this.getBatchSize(), this.getParallelism());
        this.source = new JmsStreamSource(this, Objects.requireNonNull(jmsConsumerMeta.jmsDelegate), this.getReceiverTimeout(jmsConsumerMeta));
        return superStatus;
    }

    private int getReceiverTimeout(JmsConsumerMeta meta) {
        try {
            return Integer.parseInt(meta.receiveTimeout);
        }
        catch (NumberFormatException nfe) {
            this.logError(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumer.ReceiveTimeoutInvalid", (String[])new String[0]));
            return -1;
        }
    }

    private boolean validateParams(JmsConsumerMeta meta) {
        return this.getReceiverTimeout(meta) > -1;
    }
}

