/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class JsonUtils {
    private static TimeZone GMT_TZ = TimeZone.getTimeZone("GMT");

    public static String formatDateRfc822(Date date, String timeZoneId) {
        if (date != null) {
            TimeZone tZone = "GMT".equals(timeZoneId) ? GMT_TZ : TimeZone.getTimeZone(timeZoneId);
            SimpleDateFormat dateFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            dateFormater.setTimeZone(tZone);
            return dateFormater.format(date);
        }
        return null;
    }

    public static String formatDateRfc822(Date date) {
        return JsonUtils.formatDateRfc822(date, "GMT");
    }

    public static Date parseDateRfc822(String str) {
        if (str != null) {
            try {
                SimpleDateFormat dateFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                dateFormater.setTimeZone(GMT_TZ);
                return dateFormater.parse(str);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return null;
    }
}

