/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.tests;

import java.util.Arrays;
import java.util.HashSet;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.impl.cluster.tests.ClusterRuntimeTestEntry;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.hadoop.NoShimSpecifiedException;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopConfigurationProvider;
import org.pentaho.runtime.test.i18n.MessageGetter;
import org.pentaho.runtime.test.i18n.MessageGetterFactory;
import org.pentaho.runtime.test.result.RuntimeTestEntrySeverity;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;
import org.pentaho.runtime.test.result.RuntimeTestResultSummary;
import org.pentaho.runtime.test.result.org.pentaho.runtime.test.result.impl.RuntimeTestResultSummaryImpl;
import org.pentaho.runtime.test.test.impl.BaseRuntimeTest;

public class TestShimConfig
extends BaseRuntimeTest {
    public static final String HADOOP_CONFIGURATION_TEST_SHIM_CONFIG = "hadoopConfigurationTestShimXConfig";
    public static final String TEST_SHIM_CONFIG_NAME = "TestShimConfig.Name";
    public static final String TEST_SHIM_CONFIG_FS_MATCH_DESC = "TestShimConfig.FileSystemMatch.Desc";
    public static final String TEST_SHIM_CONFIG_FS_MATCH_MESSAGE = "TestShimConfig.FileSystemMatch.Message";
    public static final String TEST_SHIM_CONFIG_FS_NOMATCH_DESC = "TestShimConfig.FileSystemNoMatch.Desc";
    public static final String TEST_SHIM_CONFIG_FS_NOMATCH_MESSAGE = "TestShimConfig.FileSystemNoMatch.Message";
    private static final Class<?> PKG = TestShimConfig.class;
    private final MessageGetterFactory messageGetterFactory;
    private final MessageGetter messageGetter;
    private final HadoopConfigurationBootstrap hadoopConfigurationBootstrap;

    public TestShimConfig(MessageGetterFactory messageGetterFactory) {
        this(messageGetterFactory, HadoopConfigurationBootstrap.getInstance());
    }

    public TestShimConfig(MessageGetterFactory messageGetterFactory, HadoopConfigurationBootstrap hadoopConfigurationBootstrap) {
        super(NamedCluster.class, "Hadoop Configuration", HADOOP_CONFIGURATION_TEST_SHIM_CONFIG, messageGetterFactory.create(PKG).getMessage(TEST_SHIM_CONFIG_NAME, new String[0]), true, new HashSet<String>(Arrays.asList("hadoopConfigurationTestShimLoad")));
        this.messageGetterFactory = messageGetterFactory;
        this.messageGetter = messageGetterFactory.create(PKG);
        this.hadoopConfigurationBootstrap = hadoopConfigurationBootstrap;
    }

    public RuntimeTestResultSummary runTest(Object objectUnderTest) {
        String activeConfigurationId = "";
        try {
            activeConfigurationId = this.hadoopConfigurationBootstrap.getWillBeActiveConfigurationId();
            HadoopConfigurationProvider hadoopConfigurationProvider = this.hadoopConfigurationBootstrap.getProvider();
            HadoopConfiguration hadoopConfiguration = hadoopConfigurationProvider.getActiveConfiguration();
            activeConfigurationId = hadoopConfiguration.getIdentifier();
            Configuration config = hadoopConfiguration.getHadoopShim().createConfiguration();
            String defaultFS = config.get("fs.default.name");
            NamedCluster namedCluster = (NamedCluster)objectUnderTest;
            Variables variables = new Variables();
            variables.initializeVariablesFrom(null);
            StringBuilder ncFS = new StringBuilder(namedCluster.getStorageScheme() + "://");
            ncFS.append(variables.environmentSubstitute(namedCluster.getHdfsHost()));
            String port = variables.environmentSubstitute(namedCluster.getHdfsPort());
            if (!Const.isEmpty((String)port)) {
                ncFS.append(":");
                ncFS.append(port);
            }
            if (!ncFS.toString().equalsIgnoreCase(defaultFS)) {
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(TEST_SHIM_CONFIG_FS_NOMATCH_DESC, new String[0]), this.messageGetter.getMessage(TEST_SHIM_CONFIG_FS_NOMATCH_MESSAGE, new String[]{ncFS.toString()}), ClusterRuntimeTestEntry.DocAnchor.SHIM_LOAD));
            }
            return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.INFO, this.messageGetter.getMessage(TEST_SHIM_CONFIG_FS_MATCH_DESC, new String[0]), this.messageGetter.getMessage(TEST_SHIM_CONFIG_FS_MATCH_MESSAGE, new String[0]), ClusterRuntimeTestEntry.DocAnchor.SHIM_LOAD));
        }
        catch (NoShimSpecifiedException e) {
            return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.ERROR, this.messageGetter.getMessage("TestShimLoad.NoShimSpecified.Desc", new String[0]), e.getMessage(), (Throwable)e, ClusterRuntimeTestEntry.DocAnchor.SHIM_LOAD));
        }
        catch (ConfigurationException e) {
            return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.ERROR, this.messageGetter.getMessage("TestShimLoad.UnableToLoadShim.Desc", new String[]{activeConfigurationId}), e.getMessage(), (Throwable)e, ClusterRuntimeTestEntry.DocAnchor.SHIM_LOAD));
        }
    }
}

