/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.platform.util.client.ServiceException;

public class ClientUtil {
    public static HttpClient getClient(String userId, String password) {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        if (StringUtils.isNotEmpty((String)userId) && StringUtils.isNotEmpty((String)password)) {
            clientBuilder.setCredentials(userId, password);
        }
        return clientBuilder.build();
    }

    public static Document getResultDom4jDocument(HttpClient client, HttpUriRequest callMethod) throws ServiceException {
        try {
            HttpResponse httpResponse = client.execute(callMethod);
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new ServiceException("Web service call failed with code " + status);
            }
            InputStream in = httpResponse.getEntity().getContent();
            byte[] buffer = new byte[2048];
            int n = in.read(buffer);
            StringBuilder sb = new StringBuilder();
            while (n != -1) {
                sb.append(new String(buffer, 0, n));
                n = in.read(buffer);
            }
            String result = sb.toString();
            return DocumentHelper.parseText((String)result);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (DocumentException e) {
            throw new ServiceException((Exception)((Object)e));
        }
    }
}

