/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.BaseDatasourceService;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;
import org.pentaho.platform.engine.services.messages.Messages;

public class NonPooledOrJndiDatasourceService
extends BaseDatasourceService {
    private static final Log log = LogFactory.getLog(NonPooledOrJndiDatasourceService.class);
    String requestedDatasourceName = null;

    @Override
    protected DataSource retrieve(String dsName) throws DBDatasourceServiceException {
        DataSource ds = null;
        this.requestedDatasourceName = dsName;
        try {
            IDatasourceMgmtService datasourceMgmtSvc = this.getDatasourceMgmtService();
            IDatabaseConnection databaseConnection = datasourceMgmtSvc.getDatasourceByName(dsName);
            if (databaseConnection != null && !databaseConnection.getAccessType().equals((Object)DatabaseAccessType.JNDI)) {
                ds = this.resolveDatabaseConnection(databaseConnection);
            } else {
                try {
                    ds = this.getJndiDataSource(dsName);
                }
                catch (DBDatasourceServiceException dBDatasourceServiceException) {
                    // empty catch block
                }
            }
            if (ds == null && databaseConnection != null) {
                ds = this.getJndiDataSource(databaseConnection.getDatabaseName());
            }
            if (ds != null) {
                this.cacheManager.putInRegionCache("DataSource", (Object)dsName, (Object)ds);
            }
        }
        catch (DatasourceMgmtServiceException daoe) {
            log.debug((Object)Messages.getInstance().getErrorString("DatasourceService.DEBUG_0001_UNABLE_TO_FIND_DATASOURCE_IN_REPOSITORY", daoe.getLocalizedMessage()), (Throwable)daoe);
            try {
                return this.getJndiDataSource(dsName);
            }
            catch (DBDatasourceServiceException dse) {
                throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("DatasourceService.ERROR_0003_UNABLE_TO_GET_JNDI_DATASOURCE"), (Throwable)dse);
            }
        }
        return ds;
    }

    @Override
    protected DataSource resolveDatabaseConnection(IDatabaseConnection databaseConnection) throws DBDatasourceServiceException {
        return PooledDatasourceHelper.convert(databaseConnection);
    }
}

