/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.status;

import org.pentaho.platform.api.engine.IServerStatusChangeListener;
import org.pentaho.platform.api.engine.IServerStatusProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicStatusLogger
implements Runnable,
IServerStatusChangeListener {
    private static Logger logger = LoggerFactory.getLogger(PeriodicStatusLogger.class);
    private static int cycleTime = 30000;
    private static PeriodicStatusLogger periodicStatusLogger = new PeriodicStatusLogger();
    private static IServerStatusProvider serverStatusProvider = IServerStatusProvider.LOCATOR.getProvider();
    private static Thread runThread;
    private boolean stopFlag = false;
    private String[] lastMessages;
    private IServerStatusProvider.ServerStatus lastServerStatus;

    private PeriodicStatusLogger() {
    }

    private static PeriodicStatusLogger getInstance() {
        return periodicStatusLogger;
    }

    public static synchronized void start() {
        if (runThread != null) {
            throw new IllegalStateException("Only one instance of the PeriodicStatusLogger is allowed");
        }
        runThread = new Thread(PeriodicStatusLogger.getInstance());
        runThread.start();
    }

    public static synchronized void stop() {
        if (periodicStatusLogger == null || runThread == null) {
            throw new IllegalStateException("The PeriodicStatusLogger has not been started");
        }
        PeriodicStatusLogger.periodicStatusLogger.stopFlag = true;
        runThread = null;
    }

    @Override
    public void run() {
        this.setCurrentValues();
        while (!this.stopFlag) {
            this.logMessages();
            try {
                Thread.sleep(cycleTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void logMessages() {
        if (runThread != null && this.lastMessages != null) {
            for (String message : this.lastMessages) {
                if (logger.isInfoEnabled()) {
                    logger.info(message);
                    continue;
                }
                logger.error(message);
            }
        }
    }

    public static String[] getStatusMessages() {
        return serverStatusProvider.getStatusMessages();
    }

    public static IServerStatusProvider.ServerStatus getServerStatus() {
        return serverStatusProvider.getStatus();
    }

    public static void setCycleTime(int cycleTime) {
        PeriodicStatusLogger.cycleTime = cycleTime;
    }

    public static int getCycleTime() {
        return cycleTime;
    }

    public void onStatusChange() {
        if (this.lastMessages != serverStatusProvider.getStatusMessages() || this.lastServerStatus != serverStatusProvider.getStatus()) {
            this.setCurrentValues();
            this.logMessages();
            if (runThread != null) {
                runThread.interrupt();
            }
        }
    }

    private void setCurrentValues() {
        this.lastMessages = serverStatusProvider.getStatusMessages();
        this.lastServerStatus = serverStatusProvider.getStatus();
    }

    static {
        serverStatusProvider.registerServerStatusChangeListener((IServerStatusChangeListener)periodicStatusLogger);
    }
}

