/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoRequestContextHolderStrategy;
import org.pentaho.platform.engine.core.messages.Messages;

public class InheritableThreadLocalPentahoRequestContextHolderStrategy
implements IPentahoRequestContextHolderStrategy {
    private static final Log logger = LogFactory.getLog(InheritableThreadLocalPentahoRequestContextHolderStrategy.class);
    private static final ThreadLocal<IPentahoRequestContext> perThreadRequestContext = new InheritableThreadLocal<IPentahoRequestContext>();

    public void setRequestContext(IPentahoRequestContext requestContext) {
        perThreadRequestContext.set(requestContext);
    }

    public IPentahoRequestContext getRequestContext() {
        IPentahoRequestContext requestContext = perThreadRequestContext.get();
        if (requestContext == null) {
            logger.debug((Object)Messages.getInstance().getString("PentahoRequestContextHolder.WARN_THREAD_REQUEST_CONTEXT_NULL", Thread.currentThread().getName()));
        }
        return requestContext;
    }

    public void removeRequestContext() {
        IPentahoRequestContext requestContext = perThreadRequestContext.get();
        if (requestContext != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("PentahoRequestContextHolder.DEBUG_REMOVING_REQUEST_CONTEXT", Thread.currentThread().getName(), String.valueOf(Thread.currentThread().getId())));
            }
            if (logger.isTraceEnabled()) {
                StackTraceElement[] elements = Thread.currentThread().getStackTrace();
                logger.trace((Object)Messages.getInstance().getString("PentahoRequestContextHolder.DEBUG_THREAD_STACK_TRACE"));
                for (int i = 0; i < elements.length; ++i) {
                    logger.trace((Object)elements[i]);
                }
            }
            perThreadRequestContext.remove();
        }
    }
}

