/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetaTableLocator {
    private static final Logger LOG = LoggerFactory.getLogger(MetaTableLocator.class);
    private volatile boolean stopped = false;

    public boolean isLocationAvailable(ZKWatcher zkw) {
        return this.getMetaRegionLocation(zkw) != null;
    }

    public List<Pair<RegionInfo, ServerName>> getMetaRegionsAndLocations(ZKWatcher zkw) {
        return this.getMetaRegionsAndLocations(zkw, 0);
    }

    public List<Pair<RegionInfo, ServerName>> getMetaRegionsAndLocations(ZKWatcher zkw, int replicaId) {
        ServerName serverName = this.getMetaRegionLocation(zkw, replicaId);
        ArrayList<Pair<RegionInfo, ServerName>> list = new ArrayList<Pair<RegionInfo, ServerName>>(1);
        list.add(new Pair((Object)RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId), (Object)serverName));
        return list;
    }

    public List<RegionInfo> getMetaRegions(ZKWatcher zkw) {
        return this.getMetaRegions(zkw, 0);
    }

    public List<RegionInfo> getMetaRegions(ZKWatcher zkw, int replicaId) {
        List<Pair<RegionInfo, ServerName>> result = this.getMetaRegionsAndLocations(zkw, replicaId);
        return this.getListOfRegionInfos(result);
    }

    private List<RegionInfo> getListOfRegionInfos(List<Pair<RegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<RegionInfo> result = new ArrayList<RegionInfo>(pairs.size());
        for (Pair<RegionInfo, ServerName> pair : pairs) {
            result.add((RegionInfo)pair.getFirst());
        }
        return result;
    }

    public ServerName getMetaRegionLocation(ZKWatcher zkw) {
        try {
            RegionState state = MetaTableLocator.getMetaRegionState(zkw);
            return state.isOpened() ? state.getServerName() : null;
        }
        catch (KeeperException ke) {
            return null;
        }
    }

    public ServerName getMetaRegionLocation(ZKWatcher zkw, int replicaId) {
        try {
            RegionState state = MetaTableLocator.getMetaRegionState(zkw, replicaId);
            return state.isOpened() ? state.getServerName() : null;
        }
        catch (KeeperException ke) {
            return null;
        }
    }

    public ServerName waitMetaRegionLocation(ZKWatcher zkw, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        return this.waitMetaRegionLocation(zkw, 0, timeout);
    }

    public ServerName waitMetaRegionLocation(ZKWatcher zkw, int replicaId, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        try {
            if (ZKUtil.checkExists(zkw, zkw.znodePaths.baseZNode) == -1) {
                String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
                LOG.error(errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("KeeperException while trying to check baseZNode:", e);
        }
        ServerName sn = this.blockUntilAvailable(zkw, replicaId, timeout);
        if (sn == null) {
            throw new NotAllMetaRegionsOnlineException("Timed out; " + timeout + "ms");
        }
        return sn;
    }

    public void waitMetaRegionLocation(ZKWatcher zkw) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (!this.stopped) {
            try {
                if (this.waitMetaRegionLocation(zkw, 100L) != null) break;
                long sleepTime = System.currentTimeMillis() - startTime;
                if ((sleepTime + 1L) % 10000L != 0L) continue;
                LOG.warn("Have been waiting for meta to be assigned for " + sleepTime + "ms");
            }
            catch (NotAllMetaRegionsOnlineException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("hbase:meta still not available, sleeping and retrying. Reason: " + e.getMessage());
            }
        }
    }

    public boolean verifyMetaRegionLocation(ClusterConnection hConnection, ZKWatcher zkw, long timeout) throws InterruptedException, IOException {
        return this.verifyMetaRegionLocation(hConnection, zkw, timeout, 0);
    }

    public boolean verifyMetaRegionLocation(ClusterConnection connection, ZKWatcher zkw, long timeout, int replicaId) throws InterruptedException, IOException {
        AdminProtos.AdminService.BlockingInterface service = null;
        try {
            service = this.getMetaServerConnection(connection, zkw, timeout, replicaId);
        }
        catch (NotAllMetaRegionsOnlineException notAllMetaRegionsOnlineException) {
        }
        catch (ServerNotRunningYetException serverNotRunningYetException) {
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (RegionServerStoppedException regionServerStoppedException) {
            // empty catch block
        }
        return service != null && this.verifyRegionLocation(connection, service, this.getMetaRegionLocation(zkw, replicaId), RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId).getRegionName());
    }

    private boolean verifyRegionLocation(ClusterConnection connection, AdminProtos.AdminService.BlockingInterface hostingServer, ServerName address, byte[] regionName) {
        Throwable t;
        if (hostingServer == null) {
            LOG.info("Passed hostingServer is null");
            return false;
        }
        HBaseRpcController controller = connection.getRpcControllerFactory().newController();
        try {
            return ProtobufUtil.getRegionInfo((RpcController)controller, (AdminProtos.AdminService.BlockingInterface)hostingServer, (byte[])regionName) != null;
        }
        catch (ConnectException e) {
            t = e;
        }
        catch (RetriesExhaustedException e) {
            t = e;
        }
        catch (RemoteException e) {
            IOException ioe = e.unwrapRemoteException();
            t = ioe;
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            t = cause != null && cause instanceof EOFException ? cause : (cause != null && cause.getMessage() != null && cause.getMessage().contains("Connection reset") ? cause : e);
        }
        LOG.info("Failed verification of " + Bytes.toStringBinary((byte[])regionName) + " at address=" + address + ", exception=" + t.getMessage());
        return false;
    }

    private AdminProtos.AdminService.BlockingInterface getMetaServerConnection(ClusterConnection connection, ZKWatcher zkw, long timeout, int replicaId) throws InterruptedException, IOException {
        return MetaTableLocator.getCachedConnection(connection, this.waitMetaRegionLocation(zkw, replicaId, timeout));
    }

    private static AdminProtos.AdminService.BlockingInterface getCachedConnection(ClusterConnection connection, ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface service;
        block11: {
            if (sn == null) {
                return null;
            }
            service = null;
            try {
                service = connection.getAdmin(sn);
            }
            catch (RetriesExhaustedException e) {
                if (e.getCause() == null || !(e.getCause() instanceof ConnectException)) {
                    throw e;
                }
            }
            catch (SocketTimeoutException e) {
                LOG.debug("Timed out connecting to " + sn);
            }
            catch (NoRouteToHostException e) {
                LOG.debug("Connecting to " + sn, (Throwable)e);
            }
            catch (SocketException e) {
                LOG.debug("Exception connecting to " + sn);
            }
            catch (UnknownHostException e) {
                LOG.debug("Unknown host exception connecting to  " + sn);
            }
            catch (FailedServerException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Server " + sn + " is in failed server list.");
                }
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause();
                if (ioe instanceof ConnectException || cause != null && cause instanceof EOFException || cause != null && cause.getMessage() != null && cause.getMessage().toLowerCase(Locale.ROOT).contains("connection reset")) break block11;
                throw ioe;
            }
        }
        return service;
    }

    public static void setMetaLocation(ZKWatcher zookeeper, ServerName serverName, RegionState.State state) throws KeeperException {
        MetaTableLocator.setMetaLocation(zookeeper, serverName, 0, state);
    }

    public static void setMetaLocation(ZKWatcher zookeeper, ServerName serverName, int replicaId, RegionState.State state) throws KeeperException {
        if (serverName == null) {
            LOG.warn("Tried to set null ServerName in hbase:meta; skipping -- ServerName required");
            return;
        }
        LOG.info("Setting hbase:meta (replicaId=" + replicaId + ") location in ZooKeeper as " + serverName);
        ZooKeeperProtos.MetaRegionServer pbrsr = ZooKeeperProtos.MetaRegionServer.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)serverName)).setRpcVersion(0).setState(state.convert()).build();
        byte[] data = ProtobufUtil.prependPBMagic((byte[])pbrsr.toByteArray());
        try {
            ZKUtil.setData(zookeeper, zookeeper.znodePaths.getZNodeForReplica(replicaId), data);
        }
        catch (KeeperException.NoNodeException nne) {
            if (replicaId == 0) {
                LOG.debug("META region location doesn't exist, create it");
            } else {
                LOG.debug("META region location doesn't exist for replicaId=" + replicaId + ", create it");
            }
            ZKUtil.createAndWatch(zookeeper, zookeeper.znodePaths.getZNodeForReplica(replicaId), data);
        }
    }

    public static RegionState getMetaRegionState(ZKWatcher zkw) throws KeeperException {
        return MetaTableLocator.getMetaRegionState(zkw, 0);
    }

    public static RegionState getMetaRegionState(ZKWatcher zkw, int replicaId) throws KeeperException {
        ServerName serverName;
        RegionState.State state;
        block8: {
            state = RegionState.State.OPEN;
            serverName = null;
            try {
                byte[] data = ZKUtil.getData(zkw, zkw.znodePaths.getZNodeForReplica(replicaId));
                if (data != null && data.length > 0 && ProtobufUtil.isPBMagicPrefix((byte[])data)) {
                    try {
                        int prefixLen = ProtobufUtil.lengthOfPBMagic();
                        ZooKeeperProtos.MetaRegionServer rl = (ZooKeeperProtos.MetaRegionServer)ZooKeeperProtos.MetaRegionServer.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
                        if (rl.hasState()) {
                            state = RegionState.State.convert((ClusterStatusProtos.RegionState.State)rl.getState());
                        }
                        HBaseProtos.ServerName sn = rl.getServer();
                        serverName = ServerName.valueOf((String)sn.getHostName(), (int)sn.getPort(), (long)sn.getStartCode());
                        break block8;
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new DeserializationException("Unable to parse meta region location");
                    }
                }
                serverName = ProtobufUtil.parseServerNameFrom((byte[])data);
            }
            catch (DeserializationException e) {
                throw ZKUtil.convert(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (serverName == null) {
            state = RegionState.State.OFFLINE;
        }
        return new RegionState(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId), state, serverName);
    }

    public void deleteMetaLocation(ZKWatcher zookeeper) throws KeeperException {
        this.deleteMetaLocation(zookeeper, 0);
    }

    public void deleteMetaLocation(ZKWatcher zookeeper, int replicaId) throws KeeperException {
        if (replicaId == 0) {
            LOG.info("Deleting hbase:meta region location in ZooKeeper");
        } else {
            LOG.info("Deleting hbase:meta for " + replicaId + " region location in ZooKeeper");
        }
        try {
            ZKUtil.deleteNode(zookeeper, zookeeper.znodePaths.getZNodeForReplica(replicaId));
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public List<ServerName> blockUntilAvailable(ZKWatcher zkw, long timeout, Configuration conf) throws InterruptedException {
        int numReplicasConfigured = 1;
        ArrayList<ServerName> servers = new ArrayList<ServerName>();
        ServerName server = this.blockUntilAvailable(zkw, timeout);
        if (server == null) {
            return null;
        }
        servers.add(server);
        try {
            List<String> metaReplicaNodes = zkw.getMetaReplicaNodes();
            numReplicasConfigured = metaReplicaNodes.size();
        }
        catch (KeeperException e) {
            LOG.warn("Got ZK exception " + (Object)((Object)e));
        }
        for (int replicaId = 1; replicaId < numReplicasConfigured; ++replicaId) {
            servers.add(this.getMetaRegionLocation(zkw, replicaId));
        }
        return servers;
    }

    public ServerName blockUntilAvailable(ZKWatcher zkw, long timeout) throws InterruptedException {
        return this.blockUntilAvailable(zkw, 0, timeout);
    }

    public ServerName blockUntilAvailable(ZKWatcher zkw, int replicaId, long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (zkw == null) {
            throw new IllegalArgumentException();
        }
        long startTime = System.currentTimeMillis();
        ServerName sn = null;
        while ((sn = this.getMetaRegionLocation(zkw, replicaId)) == null && System.currentTimeMillis() - startTime <= timeout - 200L) {
            Thread.sleep(200L);
        }
        return sn;
    }

    public void stop() {
        if (!this.stopped) {
            LOG.debug("Stopping MetaTableLocator");
            this.stopped = true;
        }
    }
}

