/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs;

import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.kettle.plugins.hdfs.vfs.HadoopVfsFileChooserDialog;
import org.pentaho.big.data.kettle.plugins.hdfs.vfs.MapRFSFileChooserDialog;
import org.pentaho.big.data.kettle.plugins.hdfs.vfs.NamedClusterVfsFileChooserDialog;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

@LifecyclePlugin(id="HdfsLifecycleListener", name="HdfsLifecycleListener")
public class HdfsLifecycleListener
implements LifecycleListener {
    private final int hdfsPriority = 150;
    private final int maprPriority = 160;
    private final int ncPriority = 110;
    private final NamedClusterService ncService;
    private final RuntimeTestActionService rtTestActServ;
    private final RuntimeTester rtTester;
    private HadoopVfsFileChooserDialog hdfsFileChooserDialog;
    private MapRFSFileChooserDialog mapRFSFileChooserDialog;
    private NamedClusterVfsFileChooserDialog ncFileChooserDialog;

    public HdfsLifecycleListener(NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.ncService = namedClusterService;
        this.rtTestActServ = runtimeTestActionService;
        this.rtTester = runtimeTester;
    }

    public void onStart(LifeEventHandler lifeEventHandler) throws LifecycleException {
        final Spoon spoon = Spoon.getInstance();
        spoon.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                VfsFileChooserDialog dialog = spoon.getVfsFileChooserDialog(null, null);
                HdfsLifecycleListener.this.hdfsFileChooserDialog = new HadoopVfsFileChooserDialog("hdfs", "HDFS", dialog, null, null, HdfsLifecycleListener.this.ncService, HdfsLifecycleListener.this.rtTestActServ, HdfsLifecycleListener.this.rtTester);
                dialog.addVFSUIPanel(Integer.valueOf(150), (CustomVfsUiPanel)HdfsLifecycleListener.this.hdfsFileChooserDialog);
                HdfsLifecycleListener.this.mapRFSFileChooserDialog = new MapRFSFileChooserDialog("maprfs", "MapRFS", dialog);
                dialog.addVFSUIPanel(Integer.valueOf(160), (CustomVfsUiPanel)HdfsLifecycleListener.this.mapRFSFileChooserDialog);
                HdfsLifecycleListener.this.ncFileChooserDialog = new NamedClusterVfsFileChooserDialog("hc", "Hadoop Cluster", dialog, null, null, HdfsLifecycleListener.this.ncService, HdfsLifecycleListener.this.rtTestActServ, HdfsLifecycleListener.this.rtTester);
                dialog.addVFSUIPanel(Integer.valueOf(110), (CustomVfsUiPanel)HdfsLifecycleListener.this.ncFileChooserDialog);
            }
        });
    }

    public void onExit(LifeEventHandler lifeEventHandler) throws LifecycleException {
    }
}

