/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.net.InetAddress;
import java.net.ServerSocket;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;

public class EmbeddedServletContainer {
    private Server server;
    private String host = null;
    private int port = -1;
    private String contextPath;
    Context context;

    public EmbeddedServletContainer(String contextPath) {
        this.contextPath = contextPath;
        this.server = new Server(0);
        this.context = new Context();
        this.context.setContextPath("/" + contextPath);
        this.server.setHandler((Handler)this.context);
    }

    public void addServletEndpoint(String servletPath, Class servletClass) {
        this.context.addServlet(new ServletHolder(servletClass), servletPath);
    }

    public void addFilter(String filterPath, Class filterClass) {
        this.context.addFilter(new FilterHolder(filterClass), filterPath, 0);
    }

    public void start() throws Exception {
        this.host = InetAddress.getLocalHost().getHostName();
        ServerSocket ss = new ServerSocket(0);
        this.port = ss.getLocalPort();
        ss.close();
        this.server.getConnectors()[0].setHost(this.host);
        this.server.getConnectors()[0].setPort(this.port);
        this.server.start();
        System.out.println("Running embedded servlet container at: http://" + this.host + ":" + this.port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getContextURL() {
        return "http://" + this.host + ":" + this.port + "/" + this.contextPath;
    }

    public String getServletURL(String servletPath) {
        String path = servletPath;
        if (path.endsWith("*")) {
            path = path.substring(0, path.length() - 1);
        }
        return this.getContextURL() + path;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.server.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.host = null;
        this.port = -1;
    }
}

