/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class WorkflowActionsRunningGetJPAExecutor
implements JPAExecutor<List<WorkflowActionBean>> {
    private final long checkAgeSecs;

    public WorkflowActionsRunningGetJPAExecutor(long checkAgeSecs) {
        this.checkAgeSecs = checkAgeSecs;
    }

    @Override
    public List<WorkflowActionBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<WorkflowActionBean> actionList = new ArrayList<WorkflowActionBean>();
        try {
            Timestamp ts = new Timestamp(System.currentTimeMillis() - this.checkAgeSecs * 1000L);
            Query q = em.createNamedQuery("GET_RUNNING_ACTIONS");
            q.setParameter("lastCheckTime", (Object)ts);
            List actions = q.getResultList();
            for (WorkflowActionBean a : actions) {
                WorkflowActionBean aa = this.getBeanForRunningAction(a);
                actionList.add(aa);
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0605, e);
        }
        return actionList;
    }

    @Override
    public String getName() {
        return "WorkflowActionsRunningGetJPAExecutor";
    }

    private WorkflowActionBean getBeanForRunningAction(WorkflowActionBean bean) {
        if (bean != null) {
            WorkflowActionBean action = new WorkflowActionBean();
            action.setId(bean.getId());
            action.setConf(bean.getConf());
            action.setConsoleUrl(bean.getConsoleUrl());
            action.setData(bean.getData());
            action.setErrorInfo(bean.getErrorCode(), bean.getErrorMessage());
            action.setExternalId(bean.getExternalId());
            action.setExternalStatus(bean.getExternalStatus());
            action.setName(bean.getName());
            action.setCred(bean.getCred());
            action.setRetries(bean.getRetries());
            action.setTrackerUri(bean.getTrackerUri());
            action.setTransition(bean.getTransition());
            action.setType(bean.getType());
            action.setEndTime(bean.getEndTime());
            action.setExecutionPath(bean.getExecutionPath());
            action.setLastCheckTime(bean.getLastCheckTime());
            action.setLogToken(bean.getLogToken());
            if (bean.getPending()) {
                action.setPending();
            }
            action.setPendingAge(bean.getPendingAge());
            action.setSignalValue(bean.getSignalValue());
            action.setSlaXml(bean.getSlaXml());
            action.setStartTime(bean.getStartTime());
            action.setStatus(bean.getStatus());
            action.setJobId(bean.getWfId());
            action.setUserRetryCount(bean.getUserRetryCount());
            action.setUserRetryInterval(bean.getUserRetryInterval());
            action.setUserRetryMax(bean.getUserRetryMax());
            return action;
        }
        return null;
    }
}

