/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionsDeleteForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsGetForPurgeJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class PurgeXCommand
extends WorkflowXCommand<Void> {
    private JPAService jpaService = null;
    private int olderThan;
    private int limit;
    private List<WorkflowJobBean> jobList = null;

    public PurgeXCommand(int olderThan, int limit) {
        super("purge", "purge", 0);
        this.olderThan = olderThan;
        this.limit = limit;
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED Workflow-Purge Attempting to purge Jobs older than [{0}] days.", this.olderThan);
        int actionDeleted = 0;
        if (this.jobList != null && this.jobList.size() != 0) {
            for (WorkflowJobBean w : this.jobList) {
                String wfId = w.getId();
                try {
                    this.jpaService.execute(new WorkflowJobDeleteJPAExecutor(wfId));
                    actionDeleted += this.jpaService.execute(new WorkflowActionsDeleteForPurgeJPAExecutor(wfId)).intValue();
                }
                catch (JPAExecutorException e) {
                    throw new CommandException(e);
                }
            }
            this.LOG.debug("ENDED Workflow-Purge deleted jobs :" + this.jobList.size() + " and actions " + actionDeleted);
        } else {
            this.LOG.debug("ENDED Workflow-Purge no workflow job to be deleted");
        }
        return null;
    }

    @Override
    protected String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.jobList = this.jpaService.execute(new WorkflowJobsGetForPurgeJPAExecutor(this.olderThan, this.limit));
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

