/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.pig.backend.hadoop.executionengine.tez.TezJob;
import org.apache.pig.backend.hadoop.executionengine.tez.util.MRToTezHelper;
import org.apache.pig.impl.PigImplConstants;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.tools.pigstats.tez.TezScriptState;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;

public class TezSessionManager {
    private static final Log log = LogFactory.getLog(TezSessionManager.class);
    private static ReentrantReadWriteLock sessionPoolLock;
    private static boolean shutdown;
    private static List<SessionInfo> sessionPool;

    private TezSessionManager() {
    }

    private static SessionInfo createSession(Configuration conf, Map<String, LocalResource> requestedAMResources, Credentials creds, TezJob.TezJobConfig tezJobConf) throws TezException, IOException, InterruptedException {
        TezConfiguration amConf = MRToTezHelper.getDAGAMConfFromMRConf(conf);
        TezScriptState ss = TezScriptState.get();
        ss.addDAGSettingsToConf((Configuration)amConf);
        if (amConf.getBoolean("pig.tez.configure.am.memory", true)) {
            TezSessionManager.adjustAMConfig(amConf, tezJobConf);
        }
        String jobName = conf.get("jobName", "pig");
        TezClient tezClient = TezClient.create((String)jobName, (TezConfiguration)amConf, (boolean)true, requestedAMResources, (Credentials)creds);
        try {
            tezClient.start();
            TezAppMasterStatus appMasterStatus = tezClient.getAppMasterStatus();
            if (appMasterStatus.equals((Object)TezAppMasterStatus.SHUTDOWN)) {
                throw new RuntimeException("TezSession has already shutdown");
            }
            tezClient.waitTillReady();
        }
        catch (Throwable e) {
            log.error((Object)"Exception while waiting for Tez client to be ready", e);
            tezClient.stop();
            throw new RuntimeException(e);
        }
        return new SessionInfo(tezClient, requestedAMResources);
    }

    private static void adjustAMConfig(TezConfiguration amConf, TezJob.TezJobConfig tezJobConf) {
        String amLaunchOpts = amConf.get("tez.am.launch.cmd-opts", "-XX:+PrintGCDetails -verbose:gc -XX:+PrintGCTimeStamps -XX:+UseNUMA -XX:+UseParallelGC");
        int configuredAMMaxHeap = Utils.extractHeapSizeInMB(amLaunchOpts);
        int configuredAMResourceMB = amConf.getInt("tez.am.resource.memory.mb", 1024);
        if (tezJobConf.getEstimatedTotalParallelism() > 0) {
            int additionaMem;
            int maxAMResourceMB;
            int maxAMHeap = Utils.is64bitJVM() ? 3584 : 3200;
            int requiredAMResourceMB = maxAMResourceMB = 4096;
            int requiredAMMaxHeap = maxAMHeap;
            for (int taskCount = 30000; taskCount >= 5000 && tezJobConf.getEstimatedTotalParallelism() < taskCount; taskCount -= 5000) {
                requiredAMMaxHeap = (requiredAMResourceMB -= 512) - 512;
            }
            if (tezJobConf.getTotalVertices() > 30) {
                additionaMem = 512 * (tezJobConf.getTotalVertices() / 30);
                requiredAMMaxHeap = (requiredAMResourceMB += additionaMem) - 512;
            }
            if (tezJobConf.getMaxOutputsinSingleVertex() > 10) {
                additionaMem = 256 * (tezJobConf.getMaxOutputsinSingleVertex() / 5);
                requiredAMMaxHeap = (requiredAMResourceMB += additionaMem) - 512;
            }
            requiredAMResourceMB = Math.min(maxAMResourceMB, requiredAMResourceMB);
            requiredAMMaxHeap = Math.min(maxAMHeap, requiredAMMaxHeap);
            if (requiredAMResourceMB > -1 && configuredAMResourceMB < requiredAMResourceMB) {
                amConf.setInt("tez.am.resource.memory.mb", requiredAMResourceMB);
                log.info((Object)("Increasing tez.am.resource.memory.mb from " + configuredAMResourceMB + " to " + requiredAMResourceMB + " as total estimated tasks = " + tezJobConf.getEstimatedTotalParallelism() + ", total vertices = " + tezJobConf.getTotalVertices() + ", max outputs = " + tezJobConf.getMaxOutputsinSingleVertex()));
                if (requiredAMMaxHeap > -1 && configuredAMMaxHeap < requiredAMMaxHeap) {
                    amConf.set("tez.am.launch.cmd-opts", amLaunchOpts + " -Xmx" + requiredAMMaxHeap + "M");
                    log.info((Object)("Increasing Tez AM Heap Size from " + configuredAMMaxHeap + "M to " + requiredAMMaxHeap + "M as total estimated tasks = " + tezJobConf.getEstimatedTotalParallelism() + ", total vertices = " + tezJobConf.getTotalVertices() + ", max outputs = " + tezJobConf.getMaxOutputsinSingleVertex()));
                    log.info((Object)("Value of tez.am.launch.cmd-opts is now " + amConf.get("tez.am.launch.cmd-opts")));
                }
            }
        }
    }

    private static boolean validateSessionResources(SessionInfo currentSession, Map<String, LocalResource> requestedAMResources) throws TezException, IOException {
        for (Map.Entry<String, LocalResource> entry : requestedAMResources.entrySet()) {
            if (currentSession.resources.entrySet().contains(entry)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TezClient getClient(Configuration conf, Map<String, LocalResource> requestedAMResources, Credentials creds, TezJob.TezJobConfig tezJobConf) throws TezException, IOException, InterruptedException {
        ArrayList<SessionInfo> sessionsToRemove = new ArrayList<SessionInfo>();
        SessionInfo newSession = null;
        sessionPoolLock.readLock().lock();
        try {
            if (shutdown) {
                throw new IOException("TezSessionManager is shut down");
            }
            Iterator<SessionInfo> i$ = sessionPool.iterator();
            while (i$.hasNext()) {
                SessionInfo sessionInfo;
                SessionInfo sessionInfo2 = sessionInfo = i$.next();
                synchronized (sessionInfo2) {
                    TezAppMasterStatus appMasterStatus = sessionInfo.session.getAppMasterStatus();
                    if (appMasterStatus.equals((Object)TezAppMasterStatus.SHUTDOWN)) {
                        sessionsToRemove.add(sessionInfo);
                    } else if (!sessionInfo.inUse && appMasterStatus.equals((Object)TezAppMasterStatus.READY) && TezSessionManager.validateSessionResources(sessionInfo, requestedAMResources)) {
                        sessionInfo.inUse = true;
                        TezClient tezClient = sessionInfo.session;
                        return tezClient;
                    }
                }
            }
        }
        finally {
            sessionPoolLock.readLock().unlock();
        }
        newSession = TezSessionManager.createSession(conf, requestedAMResources, creds, tezJobConf);
        newSession.inUse = true;
        sessionPoolLock.writeLock().lock();
        try {
            if (shutdown) {
                log.info((Object)("Shutting down Tez session " + newSession.session));
                newSession.session.stop();
                throw new IOException("TezSessionManager is shut down");
            }
            sessionPool.add(newSession);
            for (SessionInfo sessionToRemove : sessionsToRemove) {
                sessionPool.remove(sessionToRemove);
            }
            TezClient tezClient = newSession.session;
            return tezClient;
        }
        finally {
            sessionPoolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void freeSession(TezClient session) {
        sessionPoolLock.readLock().lock();
        try {
            Iterator<SessionInfo> i$ = sessionPool.iterator();
            while (i$.hasNext()) {
                SessionInfo sessionInfo;
                SessionInfo sessionInfo2 = sessionInfo = i$.next();
                synchronized (sessionInfo2) {
                    if (sessionInfo.session == session) {
                        sessionInfo.inUse = false;
                        return;
                    }
                }
            }
            return;
        }
        finally {
            sessionPoolLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void stopSession(TezClient session) throws TezException, IOException {
        Iterator<SessionInfo> iter = sessionPool.iterator();
        SessionInfo sessionToRemove = null;
        sessionPoolLock.readLock().lock();
        try {
            while (iter.hasNext()) {
                SessionInfo sessionInfo;
                SessionInfo sessionInfo2 = sessionInfo = iter.next();
                synchronized (sessionInfo2) {
                    if (sessionInfo.session == session) {
                        log.info((Object)("Stopping Tez session " + session));
                        String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                        System.err.println(timeStamp + " Shutting down Tez session " + ", sessionName=" + session.getClientName() + ", applicationId=" + session.getAppMasterApplicationId());
                        session.stop();
                        sessionToRemove = sessionInfo;
                        break;
                    }
                }
            }
        }
        finally {
            sessionPoolLock.readLock().unlock();
        }
        if (sessionToRemove == null) return;
        sessionPoolLock.writeLock().lock();
        try {
            sessionPool.remove(sessionToRemove);
            return;
        }
        finally {
            sessionPoolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void shutdown() {
        try {
            sessionPoolLock.writeLock().lock();
            shutdown = true;
            Iterator<SessionInfo> i$ = sessionPool.iterator();
            while (i$.hasNext()) {
                SessionInfo sessionInfo;
                SessionInfo sessionInfo2 = sessionInfo = i$.next();
                synchronized (sessionInfo2) {
                    TezClient session = sessionInfo.session;
                    try {
                        String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                        if (session.getAppMasterStatus().equals((Object)TezAppMasterStatus.SHUTDOWN)) {
                            log.info((Object)("Tez session is already shutdown " + session));
                            System.err.println(timeStamp + " Tez session is already shutdown " + session + ", sessionName=" + session.getClientName() + ", applicationId=" + session.getAppMasterApplicationId());
                            continue;
                        }
                        log.info((Object)("Shutting down Tez session " + session));
                        System.err.println(timeStamp + " Shutting down Tez session " + ", sessionName=" + session.getClientName() + ", applicationId=" + session.getAppMasterApplicationId());
                        session.stop();
                    }
                    catch (Exception e) {
                        log.error((Object)("Error shutting down Tez session " + session), (Throwable)e);
                    }
                }
            }
            sessionPool.clear();
        }
        finally {
            sessionPoolLock.writeLock().unlock();
        }
    }

    static {
        Utils.addShutdownHookWithPriority(new Runnable(){

            @Override
            public void run() {
                TezSessionManager.shutdown();
            }
        }, PigImplConstants.SHUTDOWN_HOOK_JOB_KILL_PRIORITY);
        sessionPoolLock = new ReentrantReadWriteLock();
        shutdown = false;
        sessionPool = new ArrayList<SessionInfo>();
    }

    public static class SessionInfo {
        private TezClient session;
        private Map<String, LocalResource> resources;
        private boolean inUse = false;

        SessionInfo(TezClient session, Map<String, LocalResource> resources) {
            this.session = session;
            this.resources = resources;
        }

        public Map<String, LocalResource> getResources() {
            return this.resources;
        }

        public TezClient getTezSession() {
            return this.session;
        }

        public void setInUse(boolean inUse) {
            this.inUse = inUse;
        }
    }
}

