/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.UDFEndOfAllInputNeededVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORelationToExprProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.AccumulativeTupleBuffer;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCross;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.data.AccumulativeBag;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SchemaTupleClassGenerator;
import org.apache.pig.data.SchemaTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.TupleMaker;
import org.apache.pig.data.UnlimitedNullTuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;
import org.apache.pig.pen.util.LineageTracer;

public class POForEach
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    private static final Result UNLIMITED_NULL_RESULT = new Result(0, new UnlimitedNullTuple());
    protected List<PhysicalPlan> inputPlans;
    protected List<PhysicalOperator> opsToBeReset;
    protected PhysicalOperator[] planLeafOps;
    protected byte[] resultTypes;
    protected boolean[] isToBeFlattenedArray;
    protected int noItems;
    protected transient boolean processingPlan;
    protected transient Iterator<Tuple>[] its = null;
    protected transient Object[] bags;
    protected transient Object[] data;
    protected transient BitSet earlyTermination;
    protected transient ExampleTuple tIn;
    protected transient AccumulativeTupleBuffer buffer;
    protected transient Tuple inpTuple;
    protected transient boolean endOfAllInputProcessed;
    protected boolean mapSideOnly = false;
    protected Boolean endOfAllInputProcessing = false;
    private Schema schema;
    private boolean isEarlyTerminated = false;
    private TupleMaker<? extends Tuple> tupleMaker;
    private boolean knownSize = false;

    public POForEach(OperatorKey k) {
        this(k, -1, null, null);
    }

    public POForEach(OperatorKey k, int rp) {
        this(k, rp, null, null);
    }

    public POForEach(OperatorKey k, List inp) {
        this(k, -1, inp, null);
    }

    public POForEach(OperatorKey k, int rp, List<PhysicalPlan> inp, List<Boolean> isToBeFlattened) {
        super(k, rp);
        this.setUpFlattens(isToBeFlattened);
        this.inputPlans = inp;
        this.opsToBeReset = new ArrayList<PhysicalOperator>();
        this.getLeaves();
    }

    public POForEach(OperatorKey operatorKey, int requestedParallelism, List<PhysicalPlan> innerPlans, List<Boolean> flattenList, Schema schema) {
        this(operatorKey, requestedParallelism, innerPlans, flattenList);
        this.schema = schema;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPOForEach(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "New For Each" + "(" + this.getFlatStr() + ")" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    String getFlatStr() {
        if (this.isToBeFlattenedArray == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean[] arr$ = this.isToBeFlattenedArray;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Boolean b = arr$[i$];
            sb.append(b);
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void setAccumulative() {
        super.setAccumulative();
        for (PhysicalPlan p : this.inputPlans) {
            for (PhysicalOperator po : p) {
                if (!(po instanceof ExpressionOperator) && !(po instanceof PODistinct)) continue;
                po.setAccumulative();
            }
        }
    }

    @Override
    public void setAccumStart() {
        super.setAccumStart();
        for (PhysicalPlan p : this.inputPlans) {
            for (PhysicalOperator po : p) {
                if (!(po instanceof ExpressionOperator) && !(po instanceof PODistinct)) continue;
                po.setAccumStart();
            }
        }
    }

    @Override
    public void setAccumEnd() {
        super.setAccumEnd();
        for (PhysicalPlan p : this.inputPlans) {
            for (PhysicalOperator po : p) {
                if (!(po instanceof ExpressionOperator) && !(po instanceof PODistinct)) continue;
                po.setAccumEnd();
            }
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        try {
            Result res = null;
            Result inp = null;
            if (this.processingPlan) {
                while (true) {
                    res = this.processPlan();
                    if (res.returnStatus == 0) {
                        return res;
                    }
                    if (res.returnStatus == 3) {
                        this.processingPlan = false;
                        for (PhysicalPlan plan : this.inputPlans) {
                            plan.detachInput();
                        }
                        break;
                    }
                    if (res.returnStatus == 2) {
                        return res;
                    }
                    if (res.returnStatus != 1) continue;
                }
            }
            do {
                inp = this.processInput();
                if (inp.returnStatus != 2) continue;
                return inp;
            } while (inp.returnStatus == 1);
            if (inp.returnStatus == 3) {
                if (this.parentPlan != null && this.parentPlan.endOfAllInput && !this.endOfAllInputProcessed && this.endOfAllInputProcessing.booleanValue()) {
                    inp = UNLIMITED_NULL_RESULT;
                } else {
                    return inp;
                }
            }
            this.attachInputToPlans((Tuple)inp.result);
            this.inpTuple = (Tuple)inp.result;
            for (PhysicalOperator po : this.opsToBeReset) {
                po.reset();
            }
            if (this.isAccumulative()) {
                for (int i = 0; i < this.inpTuple.size(); ++i) {
                    if (this.inpTuple.getType(i) != 120) continue;
                    this.buffer = ((AccumulativeBag)this.inpTuple.get(i)).getTuplebuffer();
                    break;
                }
                this.setAccumStart();
                while (true) {
                    if (!this.isEarlyTerminated() && this.buffer.hasNextBatch()) {
                        try {
                            this.buffer.nextBatch();
                        }
                        catch (IOException e) {
                            throw new ExecException(e);
                        }
                    } else {
                        if (this.buffer instanceof POPackage.POPackageTupleBuffer) {
                            this.inpTuple = ((POPackage.POPackageTupleBuffer)this.buffer).illustratorMarkup(null, this.inpTuple, 0);
                        }
                        this.setAccumEnd();
                    }
                    res = this.processPlan();
                    if (res.returnStatus == 5) {
                        this.attachInputToPlans((Tuple)inp.result);
                        continue;
                    }
                    if (res.returnStatus != 6) break;
                    this.attachInputToPlans(null);
                    this.earlyTerminate();
                }
                this.buffer.clear();
            } else {
                res = this.processPlan();
            }
            this.processingPlan = true;
            return res;
        }
        catch (RuntimeException e) {
            throw new ExecException("Error while executing ForEach at " + this.getOriginalLocations(), e);
        }
    }

    private boolean isEarlyTerminated() {
        return this.isEarlyTerminated;
    }

    private void earlyTerminate() {
        this.isEarlyTerminated = true;
    }

    protected Result processPlan() throws ExecException {
        int i;
        if (this.schema != null && this.tupleMaker == null) {
            this.tupleMaker = SchemaTupleFactory.getInstance(this.schema, false, SchemaTupleClassGenerator.GenContext.FOREACH);
            if (this.tupleMaker != null) {
                this.knownSize = true;
            }
        }
        if (this.tupleMaker == null) {
            this.tupleMaker = TupleFactory.getInstance();
        }
        Result res = new Result();
        if (this.its != null) {
            boolean restartIts = true;
            for (int i2 = 0; i2 < this.noItems; ++i2) {
                if (this.its[i2] == null || !this.isToBeFlattenedArray[i2]) continue;
                restartIts &= !this.its[i2].hasNext();
            }
            if (restartIts) {
                this.its = null;
                this.data = null;
            }
        }
        if (this.its == null) {
            if (this.endOfAllInputProcessed) {
                return RESULT_EOP;
            }
            this.its = new Iterator[this.noItems];
            this.bags = new Object[this.noItems];
            this.earlyTermination = new BitSet(this.noItems);
            for (i = 0; i < this.noItems; ++i) {
                Result inputData = null;
                switch (this.resultTypes[i]) {
                    case 5: 
                    case 10: 
                    case 15: 
                    case 20: 
                    case 25: 
                    case 30: 
                    case 50: 
                    case 55: 
                    case 65: 
                    case 70: 
                    case 100: 
                    case 110: 
                    case 120: {
                        inputData = this.planLeafOps[i].getNext(this.resultTypes[i]);
                        break;
                    }
                    default: {
                        int errCode = 2080;
                        String msg = "Foreach currently does not handle type " + DataType.findTypeName(this.resultTypes[i]);
                        throw new ExecException(msg, errCode, 4);
                    }
                }
                if (inputData.returnStatus == 6) {
                    if (this.earlyTermination.get(i)) continue;
                    this.earlyTermination.set(i);
                    continue;
                }
                if (inputData.returnStatus == 5) continue;
                if (inputData.returnStatus == 3) {
                    this.its = null;
                    this.bags = null;
                    return inputData;
                }
                if (inputData.returnStatus == 2) {
                    return inputData;
                }
                this.bags[i] = inputData.result;
                this.its[i] = inputData.result instanceof DataBag && this.isToBeFlattenedArray[i] ? ((DataBag)this.bags[i]).iterator() : null;
            }
            if (this.parentPlan != null && this.parentPlan.endOfAllInput && this.endOfAllInputProcessing.booleanValue()) {
                this.endOfAllInputProcessed = true;
            }
        }
        if (this.isAccumulative() && this.isAccumStarted()) {
            res.returnStatus = this.earlyTermination.cardinality() < this.noItems ? (byte)5 : (byte)6;
            return res;
        }
        block5: while (true) {
            if (this.data == null) {
                this.data = new Object[this.noItems];
                for (i = 0; i < this.noItems; ++i) {
                    if (this.isToBeFlattenedArray[i] && this.bags[i] instanceof DataBag) {
                        if (this.its[i].hasNext()) {
                            this.data[i] = this.its[i].next();
                            continue;
                        }
                        this.its = null;
                        this.data = null;
                        res.returnStatus = 1;
                        return res;
                    }
                    this.data[i] = this.bags[i];
                }
                if (POForEach.getReporter() != null) {
                    POForEach.getReporter().progress();
                }
                res.result = this.createTuple(this.data);
                res.returnStatus = 0;
                return res;
            }
            int index = this.noItems - 1;
            while (true) {
                if (index < 0) continue block5;
                if (this.its[index] != null && this.isToBeFlattenedArray[index]) {
                    if (this.its[index].hasNext()) {
                        this.data[index] = this.its[index].next();
                        res.result = this.createTuple(this.data);
                        res.returnStatus = 0;
                        return res;
                    }
                    this.its[index] = ((DataBag)this.bags[index]).iterator();
                    this.data[index] = this.its[index].next();
                }
                --index;
            }
            break;
        }
    }

    protected Tuple createTuple(Object[] data) throws ExecException {
        Tuple out = this.tupleMaker.newTuple();
        int idx = 0;
        for (int i = 0; i < data.length; ++i) {
            Object in = data[i];
            if (this.isToBeFlattenedArray[i] && in instanceof Tuple) {
                Tuple t = (Tuple)in;
                int size = t.size();
                for (int j = 0; j < size; ++j) {
                    if (this.knownSize) {
                        out.set(idx++, t.get(j));
                        continue;
                    }
                    out.append(t.get(j));
                }
                continue;
            }
            if (this.knownSize) {
                out.set(idx++, in);
                continue;
            }
            out.append(in);
        }
        if (this.inpTuple != null) {
            return this.illustratorMarkup(this.inpTuple, out, 0);
        }
        return this.illustratorMarkup2(data, out);
    }

    protected void attachInputToPlans(Tuple t) {
        for (PhysicalPlan p : this.inputPlans) {
            p.attachInput(t);
        }
    }

    public void getLeaves() {
        if (this.inputPlans != null) {
            int i = -1;
            if (this.isToBeFlattenedArray == null) {
                this.isToBeFlattenedArray = new boolean[this.inputPlans.size()];
            }
            this.planLeafOps = new PhysicalOperator[this.inputPlans.size()];
            for (PhysicalPlan p : this.inputPlans) {
                PhysicalOperator leaf;
                this.planLeafOps[++i] = leaf = (PhysicalOperator)p.getLeaves().get(0);
                if (!(leaf instanceof POProject) || leaf.getResultType() != 110 || !((POProject)leaf).isProjectToEnd()) continue;
                this.isToBeFlattenedArray[i] = true;
            }
        }
        this.reInitialize();
    }

    private void reInitialize() {
        if (this.planLeafOps != null) {
            this.noItems = this.planLeafOps.length;
            this.resultTypes = new byte[this.noItems];
            for (int i = 0; i < this.resultTypes.length; ++i) {
                this.resultTypes[i] = this.planLeafOps[i].getResultType();
            }
        } else {
            this.noItems = 0;
            this.resultTypes = null;
        }
        if (this.inputPlans != null) {
            for (PhysicalPlan pp : this.inputPlans) {
                try {
                    ResetFinder lf = new ResetFinder(pp, this.opsToBeReset);
                    lf.visit();
                }
                catch (VisitorException ve) {
                    String errMsg = "Internal Error:  Unexpected error looking for nested operators which need to be reset in FOREACH";
                    throw new RuntimeException(errMsg, ve);
                }
            }
        }
    }

    public List<PhysicalPlan> getInputPlans() {
        return this.inputPlans;
    }

    public void setInputPlans(List<PhysicalPlan> plans) {
        this.inputPlans = plans;
        this.planLeafOps = null;
        this.getLeaves();
    }

    public void addInputPlan(PhysicalPlan plan, boolean flatten) {
        this.inputPlans.add(plan);
        PhysicalOperator[] newPlanLeafOps = new PhysicalOperator[this.planLeafOps.length + 1];
        for (int i = 0; i < this.planLeafOps.length; ++i) {
            newPlanLeafOps[i] = this.planLeafOps[i];
        }
        newPlanLeafOps[this.planLeafOps.length] = (PhysicalOperator)plan.getLeaves().get(0);
        this.planLeafOps = newPlanLeafOps;
        boolean[] newIsToBeFlattenedArray = new boolean[this.isToBeFlattenedArray.length + 1];
        for (int i = 0; i < this.isToBeFlattenedArray.length; ++i) {
            newIsToBeFlattenedArray[i] = this.isToBeFlattenedArray[i];
        }
        newIsToBeFlattenedArray[this.isToBeFlattenedArray.length] = flatten;
        this.isToBeFlattenedArray = newIsToBeFlattenedArray;
        this.reInitialize();
    }

    public void setToBeFlattened(List<Boolean> flattens) {
        this.setUpFlattens(flattens);
    }

    public List<Boolean> getToBeFlattened() {
        ArrayList<Boolean> result = null;
        if (this.isToBeFlattenedArray != null) {
            result = new ArrayList<Boolean>();
            for (int i = 0; i < this.isToBeFlattenedArray.length; ++i) {
                result.add(this.isToBeFlattenedArray[i]);
            }
        }
        return result;
    }

    @Override
    public POForEach clone() throws CloneNotSupportedException {
        ArrayList<PhysicalPlan> plans = new ArrayList<PhysicalPlan>(this.inputPlans.size());
        for (PhysicalPlan plan : this.inputPlans) {
            plans.add(plan.clone());
        }
        ArrayList<Boolean> flattens = null;
        if (this.isToBeFlattenedArray != null) {
            flattens = new ArrayList<Boolean>(this.isToBeFlattenedArray.length);
            for (boolean b : this.isToBeFlattenedArray) {
                flattens.add(b);
            }
        }
        POForEach clone = new POForEach(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism, plans, flattens);
        clone.setResultType(this.getResultType());
        clone.addOriginalLocation(this.alias, this.getOriginalLocations());
        clone.endOfAllInputProcessing = this.endOfAllInputProcessing;
        clone.mapSideOnly = this.mapSideOnly;
        return clone;
    }

    public boolean inProcessing() {
        return this.processingPlan;
    }

    protected void setUpFlattens(List<Boolean> isToBeFlattened) {
        if (isToBeFlattened == null) {
            this.isToBeFlattenedArray = null;
        } else {
            this.isToBeFlattenedArray = new boolean[isToBeFlattened.size()];
            int i = 0;
            Iterator<Boolean> it = isToBeFlattened.iterator();
            while (it.hasNext()) {
                this.isToBeFlattenedArray[i++] = it.next();
            }
        }
    }

    public List<PhysicalOperator> getOpsToBeReset() {
        return this.opsToBeReset;
    }

    public void setOpsToBeReset(List<PhysicalOperator> opsToBeReset) {
        this.opsToBeReset = opsToBeReset;
    }

    private Tuple illustratorMarkup2(Object[] in, Object out) {
        if (this.illustrator != null) {
            int i;
            ExampleTuple tOut = new ExampleTuple((Tuple)out);
            this.illustrator.getLineage().insert(tOut);
            boolean synthetic = false;
            for (Object tIn : in) {
                synthetic |= ((ExampleTuple)tIn).synthetic;
                this.illustrator.getLineage().union(tOut, (Tuple)tIn);
            }
            this.illustrator.addData(tOut);
            for (i = 0; i < this.noItems && ((DataBag)this.bags[i]).size() >= 2L; ++i) {
            }
            if (i >= this.noItems && !this.illustrator.getEqClassesShared()) {
                this.illustrator.getEquivalenceClasses().get(0).add(tOut);
            }
            tOut.synthetic = synthetic;
            return tOut;
        }
        return (Tuple)out;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            ExampleTuple tOut = new ExampleTuple((Tuple)out);
            this.illustrator.addData(tOut);
            if (!this.illustrator.getEqClassesShared()) {
                this.illustrator.getEquivalenceClasses().get(0).add(tOut);
            }
            LineageTracer lineageTracer = this.illustrator.getLineage();
            lineageTracer.insert(tOut);
            tOut.synthetic = ((ExampleTuple)in).synthetic;
            lineageTracer.union((ExampleTuple)in, tOut);
            return tOut;
        }
        return (Tuple)out;
    }

    public void setMapSideOnly(boolean mapSideOnly) {
        this.mapSideOnly = mapSideOnly;
    }

    public boolean isMapSideOnly() {
        return this.mapSideOnly;
    }

    public boolean needEndOfAllInputProcessing() throws ExecException {
        try {
            for (PhysicalPlan innerPlan : this.inputPlans) {
                UDFEndOfAllInputNeededVisitor endOfAllInputNeededVisitor = new UDFEndOfAllInputNeededVisitor(innerPlan);
                endOfAllInputNeededVisitor.visit();
                if (!endOfAllInputNeededVisitor.needEndOfAllInputProcessing()) continue;
                this.endOfAllInputProcessing = true;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    private class ResetFinder
    extends PhyPlanVisitor {
        ResetFinder(PhysicalPlan plan, List<PhysicalOperator> toBeReset) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        @Override
        public void visitDistinct(PODistinct d) throws VisitorException {
            POForEach.this.opsToBeReset.add(d);
        }

        @Override
        public void visitLimit(POLimit limit) throws VisitorException {
            POForEach.this.opsToBeReset.add(limit);
        }

        @Override
        public void visitSort(POSort sort) throws VisitorException {
            POForEach.this.opsToBeReset.add(sort);
        }

        @Override
        public void visitCross(POCross c) throws VisitorException {
            POForEach.this.opsToBeReset.add(c);
        }

        @Override
        public void visitProject(POProject proj) throws VisitorException {
            if (proj instanceof PORelationToExprProject) {
                POForEach.this.opsToBeReset.add(proj);
            }
        }
    }
}

