/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.shapefilereader;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.shapefilereader.ShapeFileReaderMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class ShapeFileReaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ShapeFileReaderMeta.class;
    private Label wlShape;
    private Button wbShape;
    private Button wbcShape;
    private Text wShape;
    private FormData fdlShape;
    private FormData fdbShape;
    private FormData fdbcShape;
    private FormData fdShape;
    private Label wlDbf;
    private Button wbDbf;
    private Button wbcDbf;
    private Text wDbf;
    private FormData fdlDbf;
    private FormData fdbDbf;
    private FormData fdbcDbf;
    private FormData fdDbf;
    private ShapeFileReaderMeta input;
    private boolean backup_changed;

    public ShapeFileReaderDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (ShapeFileReaderMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(this.getImage());
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ShapeFileReaderDialog.this.input.setChanged();
            }
        };
        this.backup_changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ShapeFileReader.Step.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText("Step name ");
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlShape = new Label((Composite)this.shell, 131072);
        this.wlShape.setText("Name of the shapefile (.shp) ");
        this.props.setLook((Control)this.wlShape);
        this.fdlShape = new FormData();
        this.fdlShape.left = new FormAttachment(0, 0);
        this.fdlShape.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdlShape.right = new FormAttachment(middle, -margin);
        this.wlShape.setLayoutData((Object)this.fdlShape);
        this.wbShape = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbShape);
        this.wbShape.setText("&Browse...");
        this.fdbShape = new FormData();
        this.fdbShape.right = new FormAttachment(100, 0);
        this.fdbShape.top = new FormAttachment((Control)this.wStepname, margin);
        this.wbShape.setLayoutData((Object)this.fdbShape);
        this.wbcShape = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbcShape);
        this.wbcShape.setText("&Variable...");
        this.fdbcShape = new FormData();
        this.fdbcShape.right = new FormAttachment((Control)this.wbShape, -margin);
        this.fdbcShape.top = new FormAttachment((Control)this.wStepname, margin);
        this.wbcShape.setLayoutData((Object)this.fdbcShape);
        this.wShape = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wShape);
        this.wShape.addModifyListener(lsMod);
        this.fdShape = new FormData();
        this.fdShape.left = new FormAttachment(middle, 0);
        this.fdShape.right = new FormAttachment((Control)this.wbcShape, -margin);
        this.fdShape.top = new FormAttachment((Control)this.wStepname, margin);
        this.wShape.setLayoutData((Object)this.fdShape);
        this.wlDbf = new Label((Composite)this.shell, 131072);
        this.wlDbf.setText("Name of the DBF file (.dbf) ");
        this.props.setLook((Control)this.wlDbf);
        this.fdlDbf = new FormData();
        this.fdlDbf.left = new FormAttachment(0, 0);
        this.fdlDbf.top = new FormAttachment((Control)this.wShape, margin);
        this.fdlDbf.right = new FormAttachment(middle, -margin);
        this.wlDbf.setLayoutData((Object)this.fdlDbf);
        this.wbDbf = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbDbf);
        this.wbDbf.setText("&Browse...");
        this.fdbDbf = new FormData();
        this.fdbDbf.right = new FormAttachment(100, 0);
        this.fdbDbf.top = new FormAttachment((Control)this.wShape, margin);
        this.wbDbf.setLayoutData((Object)this.fdbDbf);
        this.wbcDbf = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbcDbf);
        this.wbcDbf.setText("&Variable...");
        this.fdbcDbf = new FormData();
        this.fdbcDbf.right = new FormAttachment((Control)this.wbDbf, -margin);
        this.fdbcDbf.top = new FormAttachment((Control)this.wShape, margin);
        this.wbcDbf.setLayoutData((Object)this.fdbcDbf);
        this.wDbf = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDbf);
        this.wDbf.addModifyListener(lsMod);
        this.fdDbf = new FormData();
        this.fdDbf.left = new FormAttachment(middle, 0);
        this.fdDbf.right = new FormAttachment((Control)this.wbcDbf, -margin);
        this.fdDbf.top = new FormAttachment((Control)this.wShape, margin);
        this.wDbf.setLayoutData((Object)this.fdDbf);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText("  &OK  ");
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText("  &Cancel  ");
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ShapeFileReaderDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ShapeFileReaderDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ShapeFileReaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wShape.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ShapeFileReaderDialog.this.wShape.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wShape.getText()));
            }
        });
        this.wbShape.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ShapeFileReaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.shp;*.SHP", "*"});
                if (ShapeFileReaderDialog.this.wShape.getText() != null) {
                    dialog.setFileName(ShapeFileReaderDialog.this.wShape.getText());
                }
                dialog.setFilterNames(new String[]{"Shape files", "All files"});
                if (dialog.open() != null) {
                    String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                    ShapeFileReaderDialog.this.wShape.setText(str);
                    if (str.toUpperCase().endsWith(".SHP") && (ShapeFileReaderDialog.this.wDbf.getText() == null || ShapeFileReaderDialog.this.wDbf.getText().length() == 0)) {
                        String strdbf = str.substring(0, str.length() - 4);
                        ShapeFileReaderDialog.this.wDbf.setText(strdbf + ".dbf");
                    }
                }
            }
        });
        this.wbcShape.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Properties sp = System.getProperties();
                Enumeration<Object> keys = sp.keys();
                int size = sp.values().size();
                String[] key = new String[size];
                String[] val = new String[size];
                String[] str = new String[size];
                int i = 0;
                while (keys.hasMoreElements()) {
                    key[i] = (String)keys.nextElement();
                    val[i] = sp.getProperty(key[i]);
                    str[i] = key[i] + "  [" + val[i] + "]";
                    ++i;
                }
                EnterSelectionDialog esd = new EnterSelectionDialog(ShapeFileReaderDialog.this.shell, str, "Select an Environment Variable", "Select an Environment Variable");
                if (esd.open() != null) {
                    int nr = esd.getSelectionNr();
                    ShapeFileReaderDialog.this.wShape.insert("%%" + key[nr] + "%%");
                    ShapeFileReaderDialog.this.wShape.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wShape.getText()));
                }
            }
        });
        this.wDbf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ShapeFileReaderDialog.this.wDbf.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wDbf.getText()));
            }
        });
        this.wbDbf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ShapeFileReaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.dbf;*.DBF", "*"});
                if (ShapeFileReaderDialog.this.wDbf.getText() != null) {
                    dialog.setFileName(ShapeFileReaderDialog.this.wDbf.getText());
                }
                dialog.setFilterNames(new String[]{"DBF files", "All files"});
                if (dialog.open() != null) {
                    String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                    ShapeFileReaderDialog.this.wDbf.setText(str);
                }
            }
        });
        this.wbcDbf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Properties sp = System.getProperties();
                Enumeration<Object> keys = sp.keys();
                int size = sp.values().size();
                String[] key = new String[size];
                String[] val = new String[size];
                String[] str = new String[size];
                int i = 0;
                while (keys.hasMoreElements()) {
                    key[i] = (String)keys.nextElement();
                    val[i] = sp.getProperty(key[i]);
                    str[i] = key[i] + "  [" + val[i] + "]";
                    ++i;
                }
                EnterSelectionDialog esd = new EnterSelectionDialog(ShapeFileReaderDialog.this.shell, str, "Select an Environment Variable", "Select an Environment Variable");
                if (esd.open() != null) {
                    int nr = esd.getSelectionNr();
                    ShapeFileReaderDialog.this.wDbf.insert("${" + key[nr] + "}");
                    ShapeFileReaderDialog.this.wDbf.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wDbf.getText()));
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ShapeFileReaderDialog.this.cancel();
            }
        });
        this.getData();
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.input.getShapeFilename() != null) {
            this.wShape.setText(this.input.getShapeFilename());
        }
        if (this.input.getDbfFilename() != null) {
            this.wDbf.setText(this.input.getDbfFilename());
        }
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backup_changed);
        this.dispose();
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.input.setShapeFilename(this.wShape.getText());
        this.input.setDbfFilename(this.wDbf.getText());
        this.dispose();
    }

    private Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ESRI.svg", (int)32, (int)32);
    }
}

