/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.shapefilereader;

import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.shapefilereader.ShapeFileReaderData;
import org.pentaho.di.shapefilereader.ShapeFileReaderMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.gis.shapefiles.Shape;
import org.pentaho.gis.shapefiles.ShapeFile;
import org.pentaho.gis.shapefiles.ShapeInterface;
import org.pentaho.gis.shapefiles.ShapePoint;
import org.pentaho.gis.shapefiles.ShapePolyLine;
import org.pentaho.gis.shapefiles.ShapePolyLineM;
import org.pentaho.gis.shapefiles.ShapePolygon;

public class ShapeFileReader
extends BaseStep
implements StepInterface {
    private ShapeFileReaderMeta meta;
    private ShapeFileReaderData data;

    public ShapeFileReader(StepMeta s, StepDataInterface stepDataInterface, int c, TransMeta t, Trans dis) {
        super(s, stepDataInterface, c, t, dis);
    }

    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleStepException {
        this.meta = (ShapeFileReaderMeta)smi;
        this.data = (ShapeFileReaderData)sdi;
        boolean retval = true;
        if (this.data.shapeNr >= this.data.shapeFile.getNrShapes()) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this);
        }
        Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        ShapeInterface si = this.data.shapeFile.getShape(this.data.shapeNr);
        switch (si.getType()) {
            case 23: {
                ShapePolyLineM eplm = (ShapePolyLineM)si;
                int partnr = 0;
                for (int j = 0; j < eplm.nrpoints; ++j) {
                    for (int k = 0; k < eplm.nrparts; ++k) {
                        if (j != eplm.part_starts[k]) continue;
                        ++partnr;
                    }
                    int outputIndex = 0;
                    outputRow[outputIndex++] = this.meta.getShapeFilename();
                    outputRow[outputIndex++] = this.data.shapeFile.getFileHeader().getShapeTypeDesc();
                    outputRow[outputIndex++] = new Long(this.data.shapeNr + 1);
                    outputRow[outputIndex++] = new Long(partnr);
                    outputRow[outputIndex++] = new Long(eplm.nrparts);
                    outputRow[outputIndex++] = new Long(j + 1);
                    outputRow[outputIndex++] = new Long(eplm.nrpoints);
                    outputRow[outputIndex++] = new Double(eplm.point[j].x);
                    outputRow[outputIndex++] = new Double(eplm.point[j].y);
                    outputRow[outputIndex++] = new Double(eplm.measures[j]);
                    Object[] dbfData = si.getDbfData();
                    RowMetaInterface dbfMeta = si.getDbfMeta();
                    for (int d = 0; d < dbfMeta.size(); ++d) {
                        outputRow[outputIndex++] = dbfData[d];
                    }
                    ++this.linesInput;
                    this.putRow(this.data.outputRowMeta, outputRow);
                }
                break;
            }
            case 5: {
                ShapePolygon epl = (ShapePolygon)si;
                int partnr = 0;
                for (int j = 0; j < epl.nrpoints; ++j) {
                    for (int k = 0; k < epl.nrparts; ++k) {
                        if (j != epl.part_starts[k]) continue;
                        ++partnr;
                    }
                    int outputIndex = 0;
                    outputRow[outputIndex++] = this.meta.getShapeFilename();
                    outputRow[outputIndex++] = this.data.shapeFile.getFileHeader().getShapeTypeDesc();
                    outputRow[outputIndex++] = new Long(this.data.shapeNr + 1);
                    outputRow[outputIndex++] = new Long(partnr);
                    outputRow[outputIndex++] = new Long(epl.nrparts);
                    outputRow[outputIndex++] = new Long(j + 1);
                    outputRow[outputIndex++] = new Long(epl.nrpoints);
                    outputRow[outputIndex++] = new Double(epl.point[j].x);
                    outputRow[outputIndex++] = new Double(epl.point[j].y);
                    outputRow[outputIndex++] = new Double(0.0);
                    Object[] dbfData = si.getDbfData();
                    RowMetaInterface dbfMeta = si.getDbfMeta();
                    for (int d = 0; d < dbfMeta.size(); ++d) {
                        outputRow[outputIndex++] = dbfData[d];
                    }
                    ++this.linesInput;
                    this.putRow(this.data.outputRowMeta, outputRow);
                }
                break;
            }
            case 3: {
                ShapePolyLine epl = (ShapePolyLine)si;
                int partnr = 0;
                for (int j = 0; j < epl.nrpoints; ++j) {
                    for (int k = 0; k < epl.nrparts; ++k) {
                        if (j != epl.part_starts[k]) continue;
                        ++partnr;
                    }
                    int outputIndex = 0;
                    outputRow[outputIndex++] = this.meta.getShapeFilename();
                    outputRow[outputIndex++] = this.data.shapeFile.getFileHeader().getShapeTypeDesc();
                    outputRow[outputIndex++] = new Long(this.data.shapeNr + 1);
                    outputRow[outputIndex++] = new Long(partnr);
                    outputRow[outputIndex++] = new Long(epl.nrparts);
                    outputRow[outputIndex++] = new Long(j + 1);
                    outputRow[outputIndex++] = new Long(epl.nrpoints);
                    outputRow[outputIndex++] = new Double(epl.point[j].x);
                    outputRow[outputIndex++] = new Double(epl.point[j].y);
                    outputRow[outputIndex++] = new Double(0.0);
                    Object[] dbfData = si.getDbfData();
                    RowMetaInterface dbfMeta = si.getDbfMeta();
                    for (int d = 0; d < dbfMeta.size(); ++d) {
                        outputRow[outputIndex++] = dbfData[d];
                    }
                    ++this.linesInput;
                    this.putRow(this.data.outputRowMeta, outputRow);
                }
                break;
            }
            case 1: {
                ShapePoint ep = (ShapePoint)si;
                int outputIndex = 0;
                outputRow[outputIndex++] = this.meta.getShapeFilename();
                outputRow[outputIndex++] = this.data.shapeFile.getFileHeader().getShapeTypeDesc();
                outputRow[outputIndex++] = new Long(this.data.shapeNr);
                outputRow[outputIndex++] = new Long(0L);
                outputRow[outputIndex++] = new Long(0L);
                outputRow[outputIndex++] = new Long(0L);
                outputRow[outputIndex++] = new Long(0L);
                outputRow[outputIndex++] = new Double(ep.x);
                outputRow[outputIndex++] = new Double(ep.y);
                outputRow[outputIndex++] = new Double(0.0);
                Object[] dbfData = si.getDbfData();
                RowMetaInterface dbfMeta = si.getDbfMeta();
                for (int d = 0; d < dbfMeta.size(); ++d) {
                    outputRow[outputIndex++] = dbfData[d];
                }
                ++this.linesInput;
                this.putRow(this.data.outputRowMeta, outputRow);
                break;
            }
            default: {
                System.out.println("Unable to parse shape type [" + Shape.getEsriTypeDesc(si.getType()) + "] : not yet implemented.");
                throw new KettleStepException("Unable to parse shape type [" + Shape.getEsriTypeDesc(si.getType()) + "] : not yet implemented.");
            }
        }
        ++this.data.shapeNr;
        if (this.linesInput % 50000L == 0L) {
            this.logBasic("linenr " + this.linesInput);
        }
        return retval;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ShapeFileReaderMeta)smi;
        this.data = (ShapeFileReaderData)sdi;
        if (super.init((StepMetaInterface)this.meta, (StepDataInterface)this.data)) {
            if (this.meta.getShapeFilename() == null || this.meta.getDbfFilename() == null || this.meta.getShapeFilename().length() == 0 || this.meta.getDbfFilename().length() == 0) {
                this.logError("We need both a shapefile and a DBF file.");
                return false;
            }
            this.data.shapeFile = new ShapeFile(this.log, this.meta.getShapeFilename(), this.meta.getDbfFilename());
            try {
                this.data.shapeFile.readFile();
            }
            catch (Exception e) {
                this.logError("Unable to read shapefile [" + this.meta.getShapeFilename() + "] because of an error: " + e.toString());
                return false;
            }
            this.data.shapeNr = 0;
        }
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ShapeFileReaderMeta)smi;
        this.data = (ShapeFileReaderData)sdi;
        super.dispose(smi, sdi);
    }

    public void run() {
        this.logBasic("Starting to run...");
        try {
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error", e);
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logBasic("Finished, processed " + this.linesInput + " rows, written " + this.linesWritten + " lines.");
            this.markStop();
        }
    }
}

