/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.ResultSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.ValueMetaInterface;

public class MSSQLServerDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    @Override
    public boolean supportsCatalogs() {
        return false;
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1433;
        }
        return -1;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "net.sourceforge.jtds.jdbc.Driver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        StringBuilder sb = new StringBuilder("jdbc:jtds:sqlserver://");
        sb.append(hostname);
        if (port != null && port.length() > 0) {
            sb.append(":");
            sb.append(port);
        }
        sb.append("/");
        sb.append(databaseName);
        return sb.toString();
    }

    @Override
    public String getSchemaTableCombination(String schema_name, String table_part) {
        if (this.isUsingDoubleDecimalAsSchemaTableSeparator()) {
            return schema_name + ".." + table_part;
        }
        return schema_name + "." + table_part;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsSynonyms() {
        return false;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT TOP 1 * FROM " + tableName;
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT TOP 1 " + columnname + " FROM " + tableName;
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        StringBuilder sql = new StringBuilder(128);
        for (int i = 0; i < tableNames.length; ++i) {
            sql.append("SELECT top 0 * FROM ").append(tableNames[i]).append(" WITH (UPDLOCK, HOLDLOCK);").append(Const.CR);
        }
        return sql.toString();
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP COLUMN " + v.getName() + Const.CR;
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "DATETIME";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BIT";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "BIGINT PRIMARY KEY IDENTITY(0,1)";
                        break;
                    }
                    retval = retval + "BIGINT PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 18) {
                        retval = retval + "DECIMAL(" + length + ",0)";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                if (precision > 0 && length > 0) {
                    retval = retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = retval + "FLOAT(53)";
                break;
            }
            case 2: {
                if (length < this.getMaxVARCHARLength()) {
                    if (length > 0) {
                        retval = retval + "VARCHAR(" + length + ")";
                        break;
                    }
                    retval = retval + "VARCHAR(100)";
                    break;
                }
                retval = retval + "TEXT";
                break;
            }
            case 8: {
                retval = retval + "VARBINARY(MAX)";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String getSQLListOfProcedures(String schemaName) {
        return "select o.name from sysobjects o, sysusers u where  xtype in ( 'FN', 'P' ) and o.uid = u.uid order by o.name";
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ABSOLUTE", "ACTION", "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALIAS", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "BACKUP", "BEFORE", "BEGIN", "BETWEEN", "BINARY", "BIT", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BREAK", "BROWSE", "BULK", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHECK", "CHECKPOINT", "CLASS", "CLOB", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "COMPLETION", "COMPUTE", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATABASE", "DATE", "DAY", "DBCC", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DENY", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DESTROY", "DESTRUCTOR", "DETERMINISTIC", "DIAGNOSTICS", "DICTIONARY", "DISCONNECT", "DISK", "DISTINCT", "DISTRIBUTED", "DOMAIN", "DOUBLE", "DROP", "DUMMY", "DUMP", "DYNAMIC", "EACH", "ELSE", "END", "END-EXEC", "EQUALS", "ERRLVL", "ESCAPE", "EVERY", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "FALSE", "FETCH", "FILE", "FILLFACTOR", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FREE", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HAVING", "HOLDLOCK", "HOST", "HOUR", "IDENTITY", "IDENTITY_INSERT", "IDENTITYCOL", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDICATOR", "INITIALIZE", "INITIALLY", "INNER", "INOUT", "INPUT", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "KEY", "KILL", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LINENO", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "MAP", "MATCH", "MINUTE", "MODIFIES", "MODIFY", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NOCHECK", "NONCLUSTERED", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OBJECT", "OF", "OFF", "OFFSETS", "OLD", "ON", "ONLY", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPERATION", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "OVER", "PAD", "PARAMETER", "PARAMETERS", "PARTIAL", "PATH", "PERCENT", "PLAN", "POSTFIX", "PRECISION", "PREFIX", "PREORDER", "PREPARE", "PRESERVE", "PRIMARY", "PRINT", "PRIOR", "PRIVILEGES", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READS", "READTEXT", "REAL", "RECONFIGURE", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "RELATIVE", "REPLICATION", "RESTORE", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWCOUNT", "ROWGUIDCOL", "ROWS", "RULE", "SAVE", "SAVEPOINT", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECTION", "SELECT", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETS", "SETUSER", "SHUTDOWN", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STATE", "STATEMENT", "STATIC", "STATISTICS", "STRUCTURE", "SYSTEM_USER", "TABLE", "TEMPORARY", "TERMINATE", "TEXTSIZE", "THAN", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TOP", "TRAILING", "TRAN", "TRANSACTION", "TRANSLATION", "TREAT", "TRIGGER", "TRUE", "TRUNCATE", "TSEQUAL", "UNDER", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "UPDATETEXT", "USAGE", "USE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WITHOUT", "WORK", "WRITE", "WRITETEXT", "YEAR", "ZONE"};
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"jtds-1.2.5.jar"};
    }

    @Override
    public String getExtraOptionsHelpText() {
        return "http://jtds.sourceforge.net/faq.html#urlFormat";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkIndexExists(Database database, String schemaName, String tableName, String[] idx_fields) throws KettleDatabaseException {
        String tablename = database.getDatabaseMeta().getQuotedSchemaTableCombination(schemaName, tableName);
        boolean[] exists = new boolean[idx_fields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            StringBuilder sql = new StringBuilder(128);
            sql.append("select i.name table_name, c.name column_name ");
            sql.append("from     sysindexes i, sysindexkeys k, syscolumns c ");
            sql.append("where    i.name = '" + tablename + "' ");
            sql.append("AND      i.id = k.id ");
            sql.append("AND      i.id = c.id ");
            sql.append("AND      k.colid = c.colid ");
            ResultSet res = null;
            try {
                res = database.openQuery(sql.toString());
                if (res == null) {
                    boolean row22 = false;
                    return row22;
                }
                Object[] row22 = database.getRow(res);
                while (row22 != null) {
                    String column = database.getReturnRowMeta().getString(row22, "column_name", "");
                    int idx = Const.indexOfString(column, idx_fields);
                    if (idx >= 0) {
                        exists[idx] = true;
                    }
                    row22 = database.getRow(res);
                }
            }
            finally {
                if (res != null) {
                    database.closeQuery(res);
                }
            }
            boolean all = true;
            int i = 0;
            while (i < exists.length) {
                if (!all) return all;
                if (!exists[i]) {
                    all = false;
                }
                ++i;
            }
            return all;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to determine if indexes exists on table [" + tablename + "]", e);
        }
    }

    @Override
    public String getSQLListOfSchemas() {
        return "select name from sys.schemas";
    }

    @Override
    public boolean supportsSchemas() {
        return true;
    }

    @Override
    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + versionField + ") values (1)";
    }

    @Override
    public String getSQLNextSequenceValue(String sequenceName) {
        return String.format("SELECT NEXT VALUE FOR %s", sequenceName);
    }

    @Override
    public String getSQLCurrentSequenceValue(String sequenceName) {
        return String.format("SELECT current_value FROM sys.sequences WHERE name = '%s'", sequenceName);
    }

    @Override
    public String getSQLSequenceExists(String sequenceName) {
        return String.format("SELECT 1 FROM sys.sequences WHERE name = '%s'", sequenceName);
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsSequenceNoMaxValueOption() {
        return true;
    }

    @Override
    public String getSQLListOfSequences() {
        return "SELECT name FROM sys.sequences";
    }

    @Override
    public String quoteSQLString(String string) {
        string = string.replaceAll("'", "''");
        string = string.replaceAll("\\n", "'+char(13)+'");
        string = string.replaceAll("\\r", "'+char(10)+'");
        return "'" + string + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getNextBatchIdUsingLockTables(DatabaseMeta dbm, Database ldb, String schemaName, String tableName, String fieldName) throws KettleDatabaseException {
        Long rtn = null;
        ldb.lockTables(new String[]{dbm.getQuotedSchemaTableCombination(schemaName, tableName)});
        try {
            rtn = ldb.getNextValue(null, schemaName, tableName, fieldName);
        }
        catch (Throwable throwable) {
            ldb.unlockTables(new String[]{tableName});
            throw throwable;
        }
        ldb.unlockTables(new String[]{tableName});
        return rtn;
    }

    @Override
    public boolean useSafePoints() {
        return false;
    }

    @Override
    public boolean supportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    @Override
    public int getMaxVARCHARLength() {
        return 8000;
    }
}

