/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.mqtt;

import java.nio.charset.StandardCharsets;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3Q!\u0001\u0002\u0001\t1\u0011A\"T)U)J+7-Z5wKJT!a\u0001\u0003\u0002\t5\fH\u000f\u001e\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\"\u0001A\u0007\u0011\u00079\t2#D\u0001\u0010\u0015\t\u0001B!\u0001\u0005sK\u000e,\u0017N^3s\u0013\t\u0011rB\u0001\u0005SK\u000e,\u0017N^3s!\t!\"D\u0004\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIb#\u0001\u0004Qe\u0016$WMZ\u0005\u00037q\u0011aa\u0015;sS:<'BA\r\u0017\u0011!q\u0002A!A!\u0002\u0013\u0019\u0012!\u00032s_.,'/\u0016:m\u0007\u0001A\u0001\"\t\u0001\u0003\u0002\u0003\u0006IaE\u0001\u0006i>\u0004\u0018n\u0019\u0005\nG\u0001\u0011\t\u0011)A\u0005I)\nAb\u001d;pe\u0006<W\rT3wK2\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0004\u0002\u000fM$xN]1hK&\u0011\u0011F\n\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0005\u0003GEA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\tG2LWM\u001c;JIB\u0019QCL\n\n\u0005=2\"AB(qi&|g\u000e\u0003\u00052\u0001\t\u0005\t\u0015!\u0003.\u0003!)8/\u001a:oC6,\u0007\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0011A\f7o]<pe\u0012D\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\rG2,\u0017M\\*fgNLwN\u001c\t\u0004+9:\u0004CA\u000b9\u0013\tIdCA\u0004C_>dW-\u00198\t\u0011m\u0002!\u0011!Q\u0001\nq\n1!]8t!\r)b&\u0010\t\u0003+yJ!a\u0010\f\u0003\u0007%sG\u000f\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003=\u0003E\u0019wN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005y\u0005\t2.Z3q\u00032Lg/Z%oi\u0016\u0014h/\u00197\t\u0011\u0015\u0003!\u0011!Q\u0001\nq\n1\"\\9uiZ+'o]5p]\")q\t\u0001C\u0001\u0011\u00061A(\u001b8jiz\"B\"S&M\u001b:{\u0005+\u0015*T)V\u0003\"A\u0013\u0001\u000e\u0003\tAQA\b$A\u0002MAQ!\t$A\u0002MAQa\t$A\u0002\u0011BQ\u0001\f$A\u00025BQ!\r$A\u00025BQa\r$A\u00025BQ!\u000e$A\u0002YBQa\u000f$A\u0002qBQ!\u0011$A\u0002qBQa\u0011$A\u0002qBQ!\u0012$A\u0002qBQa\u0016\u0001\u0005\u0002a\u000baa\u001c8Ti>\u0004H#A-\u0011\u0005UQ\u0016BA.\u0017\u0005\u0011)f.\u001b;\t\u000bu\u0003A\u0011\u0001-\u0002\u000f=t7\u000b^1si\u0002")
public class MQTTReceiver
extends Receiver<String> {
    private final String brokerUrl;
    private final String topic;
    private final Option<String> clientId;
    private final Option<String> username;
    private final Option<String> password;
    private final Option<Object> cleanSession;
    private final Option<Object> qos;
    private final Option<Object> connectionTimeout;
    private final Option<Object> keepAliveInterval;
    private final Option<Object> mqttVersion;

    public void onStop() {
    }

    public void onStart() {
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient client = new MqttClient(this.brokerUrl, (String)this.clientId.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return MqttClient.generateClientId();
            }
        }), (MqttClientPersistence)persistence);
        MqttConnectOptions mqttConnectionOptions = new MqttConnectOptions();
        if (this.username.isDefined() && this.password.isDefined()) {
            mqttConnectionOptions.setUserName((String)this.username.get());
            mqttConnectionOptions.setPassword(((String)this.password.get()).toCharArray());
        }
        mqttConnectionOptions.setCleanSession(BoxesRunTime.unboxToBoolean((Object)this.cleanSession.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        })));
        if (this.connectionTimeout.isDefined()) {
            mqttConnectionOptions.setConnectionTimeout(BoxesRunTime.unboxToInt((Object)this.connectionTimeout.get()));
        }
        if (this.keepAliveInterval.isDefined()) {
            mqttConnectionOptions.setKeepAliveInterval(BoxesRunTime.unboxToInt((Object)this.keepAliveInterval.get()));
        }
        if (this.mqttVersion.isDefined()) {
            mqttConnectionOptions.setMqttVersion(BoxesRunTime.unboxToInt((Object)this.mqttVersion.get()));
        }
        MqttCallback callback = new MqttCallback(this){
            private final /* synthetic */ MQTTReceiver $outer;

            public void messageArrived(String topic, MqttMessage message) {
                this.$outer.store(new String(message.getPayload(), StandardCharsets.UTF_8));
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }

            public void connectionLost(Throwable cause) {
                this.$outer.restart("Connection lost ", cause);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        client.setCallback(callback);
        client.connect(mqttConnectionOptions);
        client.subscribe(this.topic, BoxesRunTime.unboxToInt((Object)this.qos.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        })));
    }

    public MQTTReceiver(String brokerUrl, String topic, StorageLevel storageLevel, Option<String> clientId, Option<String> username, Option<String> password, Option<Object> cleanSession, Option<Object> qos, Option<Object> connectionTimeout, Option<Object> keepAliveInterval, Option<Object> mqttVersion) {
        this.brokerUrl = brokerUrl;
        this.topic = topic;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.cleanSession = cleanSession;
        this.qos = qos;
        this.connectionTimeout = connectionTimeout;
        this.keepAliveInterval = keepAliveInterval;
        this.mqttVersion = mqttVersion;
        super(storageLevel);
    }
}

