/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.googledrive.vfs.util;

import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.util.Throwables;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

public class CustomLocalServerReceiver
implements VerificationCodeReceiver {
    private Server server;
    String code;
    String error;
    private int port;
    private final String host;
    private String url;

    public CustomLocalServerReceiver() {
        this("localhost", -1);
    }

    CustomLocalServerReceiver(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRedirectUri() throws IOException {
        if (this.port == -1) {
            this.port = CustomLocalServerReceiver.getUnusedPort();
        }
        this.server = new Server(this.port);
        for (Connector c : this.server.getConnectors()) {
            c.setHost(this.host);
        }
        this.server.addHandler((Handler)new CallbackHandler());
        try {
            this.server.start();
        }
        catch (Exception var5) {
            Throwables.propagateIfPossible((Throwable)var5);
            throw new IOException(var5);
        }
        return "http://" + this.host + ":" + this.port + "/Callback/success.html";
    }

    public String waitForCode() throws IOException {
        return this.code;
    }

    public void stop() throws IOException {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception var2) {
                Throwables.propagateIfPossible((Throwable)var2);
                throw new IOException(var2);
            }
            this.server = null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private static int getUnusedPort() throws IOException {
        int var1;
        s.bind(null);
        try (Socket s = new Socket();){
            var1 = s.getLocalPort();
        }
        return var1;
    }

    public static final class Builder {
        private String host = "localhost";
        private int port = -1;

        public CustomLocalServerReceiver build() {
            return new CustomLocalServerReceiver(this.host, this.port);
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }
    }

    class CallbackHandler
    extends WebAppContext {
        CallbackHandler() {
            URL warUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("success_page");
            String warUrlString = warUrl.toExternalForm();
            this.setResourceBase(warUrlString);
            this.setContextPath("/Callback");
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            if (target.contains("/Callback")) {
                CustomLocalServerReceiver.this.error = request.getParameter("error");
                if (CustomLocalServerReceiver.this.code == null) {
                    CustomLocalServerReceiver.this.code = request.getParameter("code");
                }
                if (CustomLocalServerReceiver.this.url != null && CustomLocalServerReceiver.this.error != null && CustomLocalServerReceiver.this.error.equals("access_denied")) {
                    response.sendRedirect(CustomLocalServerReceiver.this.url);
                } else {
                    super.handle(target, request, response, dispatch);
                }
                ((Request)request).setHandled(true);
            }
        }
    }
}

