/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.mapreduce;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceFactory;
import org.pentaho.big.data.impl.shim.mapreduce.MapReduceServiceImpl;
import org.pentaho.bigdata.api.mapreduce.MapReduceService;
import org.pentaho.bigdata.api.mapreduce.TransformationVisitorService;
import org.pentaho.hadoop.shim.HadoopConfiguration;

public class MapReduceServiceFactoryImpl
implements NamedClusterServiceFactory<MapReduceService> {
    private final boolean isActiveConfiguration;
    private final HadoopConfiguration hadoopConfiguration;
    private final ExecutorService executorService;
    private final List<TransformationVisitorService> visitorServices;

    public MapReduceServiceFactoryImpl(boolean isActiveConfiguration, HadoopConfiguration hadoopConfiguration, ExecutorService executorService, List<TransformationVisitorService> visitorServices) {
        this.isActiveConfiguration = isActiveConfiguration;
        this.hadoopConfiguration = hadoopConfiguration;
        this.executorService = executorService;
        this.visitorServices = visitorServices;
    }

    public Class<MapReduceService> getServiceClass() {
        return MapReduceService.class;
    }

    public boolean canHandle(NamedCluster namedCluster) {
        boolean ncState = namedCluster == null ? true : !namedCluster.isUseGateway();
        return this.isActiveConfiguration && ncState;
    }

    public MapReduceService create(NamedCluster namedCluster) {
        return new MapReduceServiceImpl(namedCluster, this.hadoopConfiguration, this.executorService, this.visitorServices);
    }
}

