/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.aggregation;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.pentaho.pms.schema.concept.types.ConceptPropertyBase;
import org.pentaho.pms.schema.concept.types.ConceptPropertyType;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;

public class ConceptPropertyAggregation
extends ConceptPropertyBase
implements Cloneable {
    public static final ConceptPropertyAggregation NONE = new ConceptPropertyAggregation("aggregation", AggregationSettings.NONE);
    public static final ConceptPropertyAggregation SUM = new ConceptPropertyAggregation("aggregation", AggregationSettings.SUM);
    public static final ConceptPropertyAggregation AVERAGE = new ConceptPropertyAggregation("aggregation", AggregationSettings.AVERAGE);
    public static final ConceptPropertyAggregation COUNT = new ConceptPropertyAggregation("aggregation", AggregationSettings.COUNT);
    public static final ConceptPropertyAggregation MINIMUM = new ConceptPropertyAggregation("aggregation", AggregationSettings.MINIMUM);
    public static final ConceptPropertyAggregation MAXIMUM = new ConceptPropertyAggregation("aggregation", AggregationSettings.MAXIMUM);
    private AggregationSettings value;

    public ConceptPropertyAggregation(String name, AggregationSettings value) {
        this(name, value, false);
    }

    public ConceptPropertyAggregation(String name, AggregationSettings value, boolean required) {
        super(name, required);
        this.value = value;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.getId()).append(this.isRequired()).append((Object)this.value).toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ConceptPropertyAggregation rtn = (ConceptPropertyAggregation)super.clone();
        if (this.value != null) {
            rtn.value = new AggregationSettings(this.value.getType());
        }
        return rtn;
    }

    @Override
    public ConceptPropertyType getType() {
        return ConceptPropertyType.AGGREGATION;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = (AggregationSettings)value;
    }

    @Override
    public boolean equals(Object obj) {
        return this.value.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

