/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Props;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.SqlDataSource;
import org.pentaho.metadata.model.SqlPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.security.Security;
import org.pentaho.metadata.model.concept.security.SecurityOwner;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.TargetTableType;
import org.pentaho.metadata.util.SQLModelGeneratorException;
import org.pentaho.pms.util.Settings;

public class SQLModelGenerator {
    String modelName;
    int[] columnTypes;
    String[] columnNames;
    String query;
    String connectionName;
    Boolean securityEnabled;
    List<String> users;
    List<String> roles;
    int defaultAcls;
    String createdBy;
    String dbType;

    public SQLModelGenerator() {
        if (!Props.isInitialized()) {
            Props.init((int)0);
        }
    }

    public SQLModelGenerator(String modelName, String connectionName, int[] columnTypes, String[] columnNames, String query, Boolean securityEnabled, List<String> users, List<String> roles, int defaultAcls, String createdBy) {
        if (!Props.isInitialized()) {
            Props.init((int)0);
        }
        this.query = query;
        this.connectionName = connectionName;
        this.columnTypes = columnTypes;
        this.columnNames = columnNames;
        this.modelName = modelName;
        this.securityEnabled = securityEnabled;
        this.users = users;
        this.roles = roles;
        this.defaultAcls = defaultAcls;
        this.createdBy = createdBy;
    }

    public SQLModelGenerator(String modelName, String connectionName, String dbType, int[] columnTypes, String[] columnNames, String query, Boolean securityEnabled, List<String> users, List<String> roles, int defaultAcls, String createdBy) {
        this(modelName, connectionName, columnTypes, columnNames, query, securityEnabled, users, roles, defaultAcls, createdBy);
        this.dbType = dbType;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private boolean validate() {
        return !StringUtils.isEmpty((String)this.modelName) && !StringUtils.isEmpty((String)this.query) && this.columnTypes != null && this.columnTypes.length > 0 && this.columnNames != null && this.columnNames.length > 0;
    }

    public Domain generate() throws SQLModelGeneratorException {
        return this.generate(this.modelName, this.connectionName, this.columnTypes, this.columnNames, this.query, this.securityEnabled, this.users, this.roles, this.defaultAcls, this.createdBy);
    }

    public Domain generate(String modelName, String connectionName, int[] columnType, String[] columnHeader, String query, Boolean securityEnabled, List<String> users, List<String> roles, int defaultAcls, String createdBy) throws SQLModelGeneratorException {
        LocaleType locale = new LocaleType("en_US", Locale.US.getDisplayName());
        if (this.validate()) {
            SqlPhysicalModel model = new SqlPhysicalModel();
            String modelID = Settings.getBusinessModelIDPrefix() + modelName;
            model.setId(modelID);
            model.setName(new LocalizedString(locale.getCode(), modelName));
            SqlDataSource dataSource = new SqlDataSource();
            dataSource.getAttributes().put("QUOTE_ALL_FIELDS", "Y");
            dataSource.setType(SqlDataSource.DataSourceType.JNDI);
            if (this.dbType != null) {
                dataSource.setDialectType(this.dbType);
            }
            dataSource.setDatabaseName(connectionName);
            model.setDatasource(dataSource);
            SqlPhysicalTable table = new SqlPhysicalTable(model);
            table.setId("INLINE_SQL_1");
            model.getPhysicalTables().add(table);
            table.setTargetTableType(TargetTableType.INLINE_SQL);
            table.setTargetTable(query);
            try {
                LogicalModel logicalModel = new LogicalModel();
                logicalModel.setPhysicalModel(model);
                logicalModel.setId("MODEL_1");
                logicalModel.setName(new LocalizedString(locale.getCode(), modelName));
                logicalModel.setDescription(new LocalizedString(locale.getCode(), "This is the data model for " + modelName));
                Category mainCategory = new Category(logicalModel);
                String categoryID = Settings.getBusinessCategoryIDPrefix() + modelName;
                mainCategory.setId(categoryID);
                mainCategory.setName(new LocalizedString(locale.getCode(), modelName));
                LogicalTable logicalTable = new LogicalTable(logicalModel, table);
                logicalTable.setId("LOGICAL_TABLE_1");
                logicalModel.getLogicalTables().add(logicalTable);
                for (int i = 0; i < columnHeader.length; ++i) {
                    SqlPhysicalColumn column = new SqlPhysicalColumn(table);
                    column.setId(columnHeader[i]);
                    column.setTargetColumn(columnHeader[i]);
                    column.setName(new LocalizedString(locale.getCode(), columnHeader[i]));
                    column.setDataType(SQLModelGenerator.converDataType(columnType[i]));
                    String physicalColumnID = Settings.getPhysicalColumnIDPrefix() + "_" + columnHeader[i];
                    column.setId(physicalColumnID);
                    table.getPhysicalColumns().add(column);
                    LogicalColumn logicalColumn = new LogicalColumn();
                    String columnID = Settings.getBusinessColumnIDPrefix();
                    logicalColumn.setId(columnID + columnHeader[i]);
                    logicalColumn.setAggregationType(AggregationType.NONE);
                    logicalColumn.setPhysicalColumn(column);
                    logicalColumn.setLogicalTable(logicalTable);
                    logicalTable.addLogicalColumn(logicalColumn);
                    mainCategory.addLogicalColumn(logicalColumn);
                }
                logicalModel.getCategories().add(mainCategory);
                Domain domain = new Domain();
                domain.addPhysicalModel(model);
                if (this.getCreatedBy() != null) {
                    domain.setProperty("created_by", createdBy);
                }
                if (this.isSecurityEnabled().booleanValue()) {
                    SecurityOwner owner;
                    Security security = new Security();
                    for (String user : users) {
                        owner = new SecurityOwner(SecurityOwner.OwnerType.USER, user);
                        security.putOwnerRights(owner, defaultAcls);
                    }
                    for (String role : roles) {
                        owner = new SecurityOwner(SecurityOwner.OwnerType.ROLE, role);
                        security.putOwnerRights(owner, defaultAcls);
                    }
                    logicalModel.setProperty(Concept.SECURITY_PROPERTY, security);
                }
                ArrayList<LocaleType> locales = new ArrayList<LocaleType>();
                locales.add(locale);
                domain.setLocales(locales);
                domain.addLogicalModel(logicalModel);
                domain.setId(modelName);
                return domain;
            }
            catch (Exception e) {
                throw new SQLModelGeneratorException(e);
            }
        }
        throw new SQLModelGeneratorException(Messages.getErrorString("SQLModelGenerator.ERROR_0001_INPUT_VALIDATION_FAILED", new Object[0]));
    }

    private static DataType converDataType(int type) {
        switch (type) {
            case -7: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return DataType.NUMERIC;
            }
            case -2: 
            case 2004: 
            case 2005: {
                return DataType.BINARY;
            }
            case 16: {
                return DataType.BOOLEAN;
            }
            case 91: {
                return DataType.DATE;
            }
            case 93: {
                return DataType.DATE;
            }
            case -1: 
            case 12: {
                return DataType.STRING;
            }
        }
        return DataType.UNKNOWN;
    }

    public void setSecurityEnabled(Boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public Boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setDefaultAcls(int defaultAcls) {
        this.defaultAcls = defaultAcls;
    }

    public int getDefaultAcls() {
        return this.defaultAcls;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public Boolean getSecurityEnabled() {
        return this.securityEnabled;
    }

    public int[] getColumnTypes() {
        return this.columnTypes;
    }

    public void setColumnTypes(int[] columnTypes) {
        this.columnTypes = columnTypes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }
}

