/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.impl.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.RelationshipType;
import org.pentaho.metadata.model.concept.types.TargetColumnType;
import org.pentaho.metadata.model.concept.types.TargetTableType;
import org.pentaho.metadata.query.impl.sql.MappedQuery;
import org.pentaho.metadata.query.impl.sql.Path;
import org.pentaho.metadata.query.impl.sql.SqlAndTables;
import org.pentaho.metadata.query.impl.sql.SqlOpenFormula;
import org.pentaho.metadata.query.impl.sql.graph.MqlGraph;
import org.pentaho.metadata.query.impl.sql.graph.PathType;
import org.pentaho.metadata.query.model.CombinationType;
import org.pentaho.metadata.query.model.Constraint;
import org.pentaho.metadata.query.model.Order;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.mql.dialect.JoinType;
import org.pentaho.pms.mql.dialect.SQLDialectFactory;
import org.pentaho.pms.mql.dialect.SQLDialectInterface;
import org.pentaho.pms.mql.dialect.SQLQueryModel;

public class SqlGenerator {
    private static final Log logger = LogFactory.getLog(SqlGenerator.class);
    public boolean preferClassicShortestPath = false;
    private static final String LEGACY_JOIN_ORDER = "legacy_join_order";

    protected void generateSelect(SQLQueryModel query, LogicalModel model, DatabaseMeta databaseMeta, List<Selection> selections, boolean disableDistinct, int limit, boolean group, String locale, Map<LogicalTable, String> tableAliases, Map<String, String> columnsMap, Map<String, Object> parameters, boolean genAsPreparedStatement) {
        query.setDistinct(!disableDistinct && !group);
        query.setLimit(limit);
        for (int i = 0; i < selections.size(); ++i) {
            String alias = null;
            if (columnsMap != null) {
                alias = databaseMeta.generateColumnAlias(i, selections.get(i).getLogicalColumn().getId());
                columnsMap.put(alias, selections.get(i).getLogicalColumn().getId());
                alias = databaseMeta.quoteField(alias);
            } else {
                alias = databaseMeta.quoteField(selections.get(i).getLogicalColumn().getId());
            }
            SqlAndTables sqlAndTables = SqlGenerator.getBusinessColumnSQL(model, selections.get(i), tableAliases, parameters, genAsPreparedStatement, databaseMeta, locale);
            query.addSelection(sqlAndTables.getSql(), alias);
        }
    }

    protected void generateFromAndWhere(SQLQueryModel query, List<LogicalTable> usedBusinessTables, LogicalModel model, Path path, List<Constraint> conditions, Map<LogicalTable, String> tableAliases, Map<Constraint, SqlOpenFormula> constraintFormulaMap, Map<String, Object> parameters, boolean genAsPreparedStatement, DatabaseMeta databaseMeta, String locale) throws PentahoMetadataException {
        int i;
        for (i = 0; i < usedBusinessTables.size(); ++i) {
            LogicalTable businessTable = usedBusinessTables.get(i);
            String schemaName = null;
            if (businessTable.getProperty("target_schema") != null) {
                schemaName = databaseMeta.quoteField((String)businessTable.getProperty("target_schema"));
            }
            String tableName = (String)businessTable.getProperty("target_table");
            TargetTableType type = (TargetTableType)((Object)businessTable.getProperty("target_table_type"));
            tableName = type == TargetTableType.INLINE_SQL || tableName.contains(",") ? "(" + tableName + ")" : databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
            query.addTable(tableName, databaseMeta.quoteField(tableAliases.get(businessTable)));
        }
        if (path != null) {
            for (i = 0; i < path.size(); ++i) {
                JoinType joinType;
                LogicalRelationship relation = path.getRelationship(i);
                String joinFormula = this.getJoin(model, relation, tableAliases, parameters, genAsPreparedStatement, databaseMeta, locale);
                String joinOrderKey = relation.getJoinOrderKey();
                switch (RelationshipType.getJoinType(relation.getRelationshipType())) {
                    case LEFT_OUTER: {
                        joinType = JoinType.LEFT_OUTER_JOIN;
                        break;
                    }
                    case RIGHT_OUTER: {
                        joinType = JoinType.RIGHT_OUTER_JOIN;
                        break;
                    }
                    case FULL_OUTER: {
                        joinType = JoinType.FULL_OUTER_JOIN;
                        break;
                    }
                    default: {
                        joinType = JoinType.INNER_JOIN;
                    }
                }
                String leftTableName = databaseMeta.getQuotedSchemaTableCombination((String)relation.getFromTable().getProperty("target_schema"), (String)relation.getFromTable().getProperty("target_table"));
                String leftTableAlias = databaseMeta.quoteField(tableAliases.get(relation.getFromTable()));
                String rightTableName = databaseMeta.getQuotedSchemaTableCombination((String)relation.getToTable().getProperty("target_schema"), (String)relation.getToTable().getProperty("target_table"));
                String rightTableAlias = databaseMeta.quoteField(tableAliases.get(relation.getToTable()));
                boolean legacyJoin = Boolean.TRUE.equals(model.getProperty(LEGACY_JOIN_ORDER));
                query.addJoin(leftTableName, leftTableAlias, rightTableName, rightTableAlias, joinType, joinFormula, joinOrderKey, legacyJoin);
            }
        }
        if (conditions != null) {
            boolean first = true;
            for (Constraint condition : conditions) {
                SqlOpenFormula formula = constraintFormulaMap.get(condition);
                formula.setTableAliases(tableAliases);
                if (!formula.hasAggregate()) {
                    String sqlFormula = formula.generateSQL(locale);
                    String[] usedTables = formula.getLogicalTableIDs();
                    query.addWhereFormula(sqlFormula, condition.getCombinationType().toString(), usedTables);
                    first = false;
                    continue;
                }
                query.addHavingFormula(formula.generateSQL(locale), condition.getCombinationType().toString());
            }
        }
    }

    protected void generateGroupBy(SQLQueryModel query, LogicalModel model, List<Selection> selections, Map<LogicalTable, String> tableAliases, Map<String, Object> parameters, boolean genAsPreparedStatement, DatabaseMeta databaseMeta, String locale) {
        for (Selection selection : selections) {
            if (this.hasFactsInIt(model, selection, parameters, genAsPreparedStatement, databaseMeta, locale)) continue;
            SqlAndTables sqlAndTables = SqlGenerator.getBusinessColumnSQL(model, selection, tableAliases, parameters, genAsPreparedStatement, databaseMeta, locale);
            query.addGroupBy(sqlAndTables.getSql(), null);
        }
    }

    protected void generateOrderBy(SQLQueryModel query, LogicalModel model, List<Order> orderBy, DatabaseMeta databaseMeta, String locale, Map<LogicalTable, String> tableAliases, Map<String, String> columnsMap, Map<String, Object> parameters, boolean genAsPreparedStatement) {
        if (orderBy != null) {
            for (Order orderItem : orderBy) {
                LogicalColumn businessColumn = orderItem.getSelection().getLogicalColumn();
                String alias = null;
                if (columnsMap != null) {
                    for (String key : columnsMap.keySet()) {
                        String value = columnsMap.get(key);
                        if (!value.equals(businessColumn.getId())) continue;
                        alias = key;
                        break;
                    }
                }
                SqlAndTables sqlAndTables = SqlGenerator.getBusinessColumnSQL(model, orderItem.getSelection(), tableAliases, parameters, genAsPreparedStatement, databaseMeta, locale);
                query.addOrderBy(sqlAndTables.getSql(), databaseMeta.quoteField(alias), orderItem.getType() != Order.Type.ASC ? SQLQueryModel.OrderType.DESCENDING : null);
            }
        }
    }

    private static String genString(String base, int val) {
        if (val < 10) {
            return base + "0" + val;
        }
        return base + val;
    }

    protected String generateUniqueAlias(String alias, int maxLength, Collection<String> existingAliases) {
        if (alias.length() <= maxLength) {
            if (!existingAliases.contains(alias)) {
                return alias;
            }
            if (alias.length() > maxLength - 2) {
                alias = alias.substring(0, maxLength - 2);
            }
        } else {
            alias = alias.substring(0, maxLength - 2);
        }
        int id = 1;
        String aliasWithId = SqlGenerator.genString(alias, id);
        while (existingAliases.contains(aliasWithId)) {
            aliasWithId = SqlGenerator.genString(alias, ++id);
        }
        return aliasWithId;
    }

    public MappedQuery generateSql(Query query, String locale, IMetadataDomainRepository repo, DatabaseMeta databaseMeta) throws PentahoMetadataException {
        return this.generateSql(query, locale, repo, databaseMeta, null, false);
    }

    public MappedQuery generateSql(Query query, String locale, IMetadataDomainRepository repo, DatabaseMeta databaseMeta, Map<String, Object> parameters, boolean genAsPreparedStatement) throws PentahoMetadataException {
        String mqlSecurityConstraint;
        Constraint securityConstraint = null;
        if (repo != null && StringUtils.isNotBlank((String)(mqlSecurityConstraint = repo.generateRowLevelSecurityConstraint(query.getLogicalModel())))) {
            securityConstraint = new Constraint(CombinationType.AND, mqlSecurityConstraint);
        }
        if (parameters == null && query.getParameters().size() > 0) {
            parameters = new HashMap<String, Object>();
        }
        for (Parameter param : query.getParameters()) {
            if (parameters.containsKey(param.getName())) continue;
            parameters.put(param.getName(), param.getDefaultValue());
        }
        return this.getSQL(query.getLogicalModel(), query.getSelections(), query.getConstraints(), query.getOrders(), databaseMeta, locale, parameters, genAsPreparedStatement, query.getDisableDistinct(), query.getLimit(), securityConstraint);
    }

    protected MappedQuery getSQL(LogicalModel model, List<Selection> selections, List<Constraint> conditions, List<Order> orderBy, DatabaseMeta databaseMeta, String locale, Map<String, Object> parameters, boolean genAsPreparedStatement, boolean disableDistinct, int limit, Constraint securityConstraint) throws PentahoMetadataException {
        List<LogicalTable> tabs;
        Path path;
        SQLQueryModel query = new SQLQueryModel();
        Object val = null;
        val = model.getProperty("delay_outer_join_conditions");
        if (val != null && val instanceof Boolean) {
            query.setDelayOuterJoinConditions((Boolean)val);
        }
        HashMap<String, String> columnsMap = new HashMap<String, String>();
        HashMap<Constraint, SqlOpenFormula> constraintFormulaMap = new HashMap<Constraint, SqlOpenFormula>();
        for (Constraint constraint : conditions) {
            SqlOpenFormula formula = new SqlOpenFormula(model, databaseMeta, constraint.getFormula(), null, parameters, genAsPreparedStatement);
            formula.parseAndValidate();
            constraintFormulaMap.put(constraint, formula);
        }
        if (securityConstraint != null) {
            SqlOpenFormula formula = new SqlOpenFormula(model, databaseMeta, securityConstraint.getFormula(), null, parameters, genAsPreparedStatement);
            formula.parseAndValidate();
            constraintFormulaMap.put(securityConstraint, formula);
        }
        if ((path = this.getShortestPathBetween(model, tabs = this.getTablesInvolved(model, selections, conditions, orderBy, constraintFormulaMap, parameters, genAsPreparedStatement, databaseMeta, locale, securityConstraint))) == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlGenerator.ERROR_0002_FAILED_TO_FIND_PATH", new Object[0]));
        }
        List<LogicalTable> usedBusinessTables = path.getUsedTables();
        if (path.size() == 0 && selections.size() > 0) {
            usedBusinessTables.add(selections.get(0).getLogicalColumn().getLogicalTable());
        }
        HashMap<LogicalTable, String> tableAliases = null;
        if (usedBusinessTables.size() > 0) {
            int maxAliasNameWidth = SQLDialectFactory.getSQLDialect(databaseMeta).getMaxTableNameLength();
            tableAliases = new HashMap<LogicalTable, String>();
            for (LogicalTable table : usedBusinessTables) {
                String uniqueAlias = this.generateUniqueAlias(table.getId(), maxAliasNameWidth, tableAliases.values());
                tableAliases.put(table, uniqueAlias);
            }
            boolean group = this.hasFactsInIt(model, selections, conditions, constraintFormulaMap, parameters, genAsPreparedStatement, databaseMeta, locale);
            this.generateSelect(query, model, databaseMeta, selections, disableDistinct, limit, group, locale, tableAliases, columnsMap, parameters, genAsPreparedStatement);
            this.generateFromAndWhere(query, usedBusinessTables, model, path, conditions, tableAliases, constraintFormulaMap, parameters, genAsPreparedStatement, databaseMeta, locale);
            if (group) {
                this.generateGroupBy(query, model, selections, tableAliases, parameters, genAsPreparedStatement, databaseMeta, locale);
            }
            this.generateOrderBy(query, model, orderBy, databaseMeta, locale, tableAliases, columnsMap, parameters, genAsPreparedStatement);
            if (securityConstraint != null) {
                SqlOpenFormula securityFormula = (SqlOpenFormula)constraintFormulaMap.get(securityConstraint);
                securityFormula.setTableAliases(tableAliases);
                String sqlFormula = securityFormula.generateSQL(locale);
                query.setSecurityConstraint(sqlFormula, securityFormula.hasAggregate());
            }
        }
        this.preprocessQueryModel(query, selections, tableAliases, databaseMeta);
        SQLDialectInterface dialect = SQLDialectFactory.getSQLDialect(databaseMeta);
        ArrayList<String> paramNames = null;
        String sql = dialect.generateSelectStatement(query);
        Pattern p = Pattern.compile("___PARAM\\[(.*?)\\]___");
        Matcher m = p.matcher(sql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String paramName = m.group(1);
            String repl = "?";
            if (parameters.get(paramName) instanceof Object[]) {
                Object[] paramz = (Object[])parameters.get(paramName);
                for (int i = 1; i < paramz.length; ++i) {
                    repl = repl + ", ?";
                }
            }
            m.appendReplacement(sb, repl);
            if (paramNames == null) {
                paramNames = new ArrayList<String>();
            }
            paramNames.add(paramName);
        }
        m.appendTail(sb);
        String sqlStr = sb.toString();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)sqlStr);
        }
        String sqlOutput = this.processGeneratedSql(sb.toString());
        return new MappedQuery(sqlOutput, columnsMap, selections, paramNames);
    }

    protected void preprocessQueryModel(SQLQueryModel query, List<Selection> selections, Map<LogicalTable, String> tableAliases, DatabaseMeta databaseMeta) {
    }

    protected String processGeneratedSql(String sql) {
        return sql;
    }

    protected List<LogicalTable> getTablesInvolved(LogicalModel model, List<Selection> selections, List<Constraint> conditions, List<Order> orderBy, Map<Constraint, SqlOpenFormula> constraintFormulaMap, Map<String, Object> parameters, boolean genAsPreparedStatement, DatabaseMeta databaseMeta, String locale, Constraint securityConstraint) {
        SqlAndTables sqlAndTables;
        TreeSet<LogicalTable> treeSet = new TreeSet<LogicalTable>();
        for (Selection selection : selections) {
            sqlAndTables = SqlGenerator.getBusinessColumnSQL(model, selection, null, parameters, genAsPreparedStatement, databaseMeta, locale);
            for (LogicalTable logicalTable : sqlAndTables.getUsedTables()) {
                treeSet.add(logicalTable);
            }
        }
        for (Constraint condition : conditions) {
            SqlOpenFormula formula = constraintFormulaMap.get(condition);
            List<Selection> cols = formula.getSelections();
            Iterator<Selection> iterator = cols.iterator();
            while (iterator.hasNext()) {
                Selection selection = iterator.next();
                LogicalTable businessTable2 = selection.getLogicalColumn().getLogicalTable();
                treeSet.add(businessTable2);
            }
        }
        for (Order order : orderBy) {
            sqlAndTables = SqlGenerator.getBusinessColumnSQL(model, order.getSelection(), null, parameters, genAsPreparedStatement, databaseMeta, locale);
            for (LogicalTable logicalTable : sqlAndTables.getUsedTables()) {
                treeSet.add(logicalTable);
            }
        }
        if (securityConstraint != null) {
            SqlOpenFormula formula = constraintFormulaMap.get(securityConstraint);
            List<Selection> cols = formula.getSelections();
            for (Selection selection : cols) {
                treeSet.add(selection.getLogicalColumn().getLogicalTable());
            }
        }
        return new ArrayList<LogicalTable>(treeSet);
    }

    protected boolean hasFactsInIt(LogicalModel model, List<Selection> selections, List<Constraint> conditions, Map<Constraint, SqlOpenFormula> constraintFormulaMap, Map<String, Object> parameters, boolean genAsPreparedStatement, DatabaseMeta databaseMeta, String locale) {
        for (Selection selection : selections) {
            if (!this.hasFactsInIt(model, selection, parameters, genAsPreparedStatement, databaseMeta, locale)) continue;
            return true;
        }
        if (conditions != null) {
            for (Constraint condition : conditions) {
                List<Selection> list = constraintFormulaMap.get(condition).getSelections();
                for (Selection conditionColumn : list) {
                    if (!this.hasFactsInIt(model, conditionColumn, parameters, genAsPreparedStatement, databaseMeta, locale)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean hasFactsInIt(LogicalModel model, Selection businessColumn, Map<String, Object> parameters, boolean genAsPreparedStatement, DatabaseMeta databaseMeta, String locale) {
        if (businessColumn.hasAggregate()) {
            return true;
        }
        SqlAndTables sqlAndTables = SqlGenerator.getBusinessColumnSQL(model, businessColumn, null, parameters, genAsPreparedStatement, databaseMeta, locale);
        for (Selection column : sqlAndTables.getUsedColumns()) {
            if (!column.hasAggregate()) continue;
            return true;
        }
        return false;
    }

    protected <T> List<List<T>> getSubsetsOfSize(int size, List<T> list) {
        if (size <= 0) {
            return new ArrayList<List<T>>();
        }
        return SqlGenerator.getSubsets(0, size, new ArrayList(), list);
    }

    private static <T> List<List<T>> getSubsets(int indexToStart, int subSize, List<T> toClone, List<T> origList) {
        ArrayList<List<T>> allSubsets = new ArrayList<List<T>>();
        for (int i = indexToStart; i <= origList.size() - subSize; ++i) {
            ArrayList<T> subset = new ArrayList<T>(toClone);
            subset.add(origList.get(i));
            if (subSize == 1) {
                allSubsets.add(subset);
                continue;
            }
            allSubsets.addAll(SqlGenerator.getSubsets(i + 1, subSize - 1, subset, origList));
        }
        return allSubsets;
    }

    protected Path getShortestPathBetweenOrig(LogicalModel model, List<LogicalTable> tables) {
        Path path;
        ArrayList<Path> paths = new ArrayList<Path>();
        ArrayList<LogicalTable> origSelectedTables = new ArrayList<LogicalTable>(tables);
        boolean allUsed = tables.size() == 0;
        List<LogicalTable> notSelectedTables = this.getNonSelectedTables(model, origSelectedTables);
        for (int ns = 0; ns <= notSelectedTables.size() && !allUsed; ++ns) {
            List<List<LogicalTable>> uniqueCombos = this.getSubsetsOfSize(ns, notSelectedTables);
            if (ns == 0) {
                uniqueCombos.add(new ArrayList());
            }
            for (int i = 0; i < uniqueCombos.size(); ++i) {
                List<LogicalTable> uc = uniqueCombos.get(i);
                uc.addAll(origSelectedTables);
            }
            for (int p = 0; p < uniqueCombos.size(); ++p) {
                List<LogicalTable> selectedTables = uniqueCombos.get(p);
                path = new Path();
                for (int i = 0; i < selectedTables.size(); ++i) {
                    for (int j = i + 1; j < selectedTables.size(); ++j) {
                        LogicalTable two;
                        LogicalTable one = selectedTables.get(i);
                        LogicalRelationship relationship = SqlGenerator.findRelationshipUsing(model, one, two = selectedTables.get(j));
                        if (relationship == null || path.contains(relationship)) continue;
                        path.addRelationship(relationship);
                    }
                    if (path.size() != selectedTables.size() - 1) continue;
                    paths.add(path);
                    allUsed = true;
                }
            }
        }
        int minSize = Integer.MAX_VALUE;
        int minScore = Integer.MAX_VALUE;
        Path minPath = null;
        for (int i = 0; i < paths.size(); ++i) {
            path = (Path)paths.get(i);
            if (path.size() >= minSize && (path.size() != minSize || path.score() >= minScore)) continue;
            minPath = path;
            minScore = path.score();
            minSize = path.size();
        }
        return minPath;
    }

    public Path getShortestPathBetween(LogicalModel model, List<LogicalTable> tables) {
        Object pathBuildProperty;
        logger.debug((Object)"Enter getShortestPathBetween() - new");
        if (tables.size() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Optimization 1 - one table = empty path.");
            }
            return new Path();
        }
        if (tables.size() == 2) {
            List<LogicalRelationship> rels = model.getLogicalRelationships();
            LogicalTable t1 = tables.get(0);
            LogicalTable t2 = tables.get(1);
            LogicalTable t3 = null;
            LogicalTable t4 = null;
            for (LogicalRelationship rel : rels) {
                t3 = rel.getFromTable();
                t4 = rel.getToTable();
                if ((!t3.equals(t1) || !t4.equals(t2)) && (!t3.equals(t2) || !t4.equals(t1))) continue;
                Path rtn = new Path();
                rtn.addRelationship(rel);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Optimization 2 - two tables + matching relation: " + rtn));
                }
                return rtn;
            }
        }
        String pathMethodString = (pathBuildProperty = model.getProperty("path_build_method")) != null && pathBuildProperty instanceof String ? (String)pathBuildProperty : (this.preferClassicShortestPath ? "CLASSIC" : "SHORTEST");
        PathType pathBuildMethod = null;
        if (pathMethodString.equals("CLASSIC")) {
            return this.getShortestPathBetweenOrig(model, tables);
        }
        pathBuildMethod = PathType.valueOf(pathMethodString);
        MqlGraph graph = new MqlGraph(model);
        logger.debug((Object)("Attempting to build path using technique: " + (Object)((Object)pathBuildMethod)));
        Path p = graph.getPath(pathBuildMethod, tables);
        if (p == null) {
            logger.debug((Object)"Unable to calculate shortest path for query, returning null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exiting getShortestPathBetween() " + tables + "  with result " + p));
        }
        return p;
    }

    protected List<LogicalTable> getNonSelectedTables(LogicalModel model, List<LogicalTable> selectedTables) {
        ArrayList<BusinessTableNeighbours> extra = new ArrayList<BusinessTableNeighbours>(model.getLogicalTables().size());
        ArrayList<LogicalTable> unused = new ArrayList<LogicalTable>();
        ArrayList<LogicalTable> used = new ArrayList<LogicalTable>(selectedTables);
        for (int i = 0; i < model.getLogicalTables().size(); ++i) {
            unused.add(model.getLogicalTables().get(i));
        }
        boolean anyFound = true;
        while (anyFound) {
            anyFound = false;
            Iterator iter = unused.iterator();
            while (iter.hasNext()) {
                boolean found = false;
                LogicalTable check = (LogicalTable)iter.next();
                for (int j = 0; j < used.size(); ++j) {
                    LogicalTable businessTable = (LogicalTable)used.get(j);
                    if (!check.equals(businessTable)) continue;
                    found = true;
                }
                if (found) continue;
                BusinessTableNeighbours btn = new BusinessTableNeighbours();
                btn.businessTable = check;
                btn.nrNeighbours = SqlGenerator.getNrNeighbours(model, check, used);
                if (btn.nrNeighbours <= 0) continue;
                extra.add(btn);
                used.add(check);
                iter.remove();
                anyFound = true;
            }
        }
        Collections.sort(extra);
        ArrayList<LogicalTable> retval = new ArrayList<LogicalTable>(extra.size());
        for (int i = 0; i < extra.size(); ++i) {
            BusinessTableNeighbours btn = (BusinessTableNeighbours)extra.get(i);
            if (btn.nrNeighbours <= 0) continue;
            retval.add(0, btn.businessTable);
        }
        return retval;
    }

    private static int getNrNeighbours(LogicalModel model, LogicalTable businessTable, List<LogicalTable> selectedTables) {
        int nr = 0;
        for (LogicalRelationship relationship : model.getLogicalRelationships()) {
            if (!relationship.isUsingTable(businessTable)) continue;
            boolean found = false;
            for (int s = 0; s < selectedTables.size() && !found; ++s) {
                LogicalTable selectedTable = selectedTables.get(s);
                if (!relationship.isUsingTable(selectedTable) || businessTable.equals(selectedTable)) continue;
                ++nr;
            }
        }
        return nr;
    }

    private static LogicalRelationship findRelationshipUsing(LogicalModel model, LogicalTable one, LogicalTable two) {
        for (LogicalRelationship rel : model.getLogicalRelationships()) {
            if (!rel.isUsingTable(one) || !rel.isUsingTable(two)) continue;
            return rel;
        }
        return null;
    }

    public static SqlAndTables getBusinessColumnSQL(LogicalModel businessModel, Selection column, Map<LogicalTable, String> tableAliases, Map<String, Object> parameters, boolean genAsPreparedStatement, DatabaseMeta databaseMeta, String locale) {
        String targetColumn = (String)column.getLogicalColumn().getProperty("target_column");
        LogicalTable logicalTable = column.getLogicalColumn().getLogicalTable();
        if (column.getLogicalColumn().getProperty("target_column_type") == TargetColumnType.OPEN_FORMULA) {
            try {
                SqlOpenFormula formula = new SqlOpenFormula(businessModel, logicalTable, databaseMeta, targetColumn, tableAliases, parameters, genAsPreparedStatement);
                formula.parseAndValidate();
                String formulaSql = formula.generateSQL(locale);
                if (column.hasAggregate() && !SqlGenerator.hasAggregateDefinedAlready(formulaSql, databaseMeta)) {
                    formulaSql = SqlGenerator.getFunctionExpression(column, formulaSql, databaseMeta);
                }
                return new SqlAndTables(formulaSql, formula.getLogicalTables(), formula.getSelections());
            }
            catch (PentahoMetadataException e) {
                logger.warn((Object)Messages.getErrorString("SqlGenerator.ERROR_0001_FAILED_TO_PARSE_FORMULA", targetColumn), (Throwable)e);
                return new SqlAndTables(targetColumn, logicalTable, column);
            }
        }
        String tableColumn = "";
        String tableAlias = null;
        tableAlias = tableAliases != null ? tableAliases.get(logicalTable) : logicalTable.getId();
        tableColumn = tableColumn + databaseMeta.quoteField(tableAlias);
        tableColumn = tableColumn + ".";
        tableColumn = tableColumn + databaseMeta.quoteField(targetColumn);
        if (column.hasAggregate()) {
            return new SqlAndTables(SqlGenerator.getFunctionExpression(column, tableColumn, databaseMeta), logicalTable, column);
        }
        return new SqlAndTables(tableColumn, logicalTable, column);
    }

    private static boolean hasAggregateDefinedAlready(String sql, DatabaseMeta databaseMeta) {
        String trimmed = sql.trim();
        return trimmed.startsWith(databaseMeta.getFunctionAverage() + "(") || trimmed.startsWith(databaseMeta.getFunctionCount() + "(") || trimmed.startsWith(databaseMeta.getFunctionMaximum() + "(") || trimmed.startsWith(databaseMeta.getFunctionMinimum() + "(") || trimmed.startsWith(databaseMeta.getFunctionSum() + "(");
    }

    public static String getFunctionExpression(Selection column, String tableColumn, DatabaseMeta databaseMeta) {
        String expression = SqlGenerator.getFunction(column, databaseMeta);
        switch (column.getActiveAggregationType()) {
            case COUNT_DISTINCT: {
                expression = expression + "(DISTINCT " + tableColumn + ")";
                break;
            }
            default: {
                expression = expression + "(" + tableColumn + ")";
            }
        }
        return expression;
    }

    private static String getFunction(Selection column, DatabaseMeta databaseMeta) {
        String fn = "";
        switch (column.getActiveAggregationType()) {
            case AVERAGE: {
                fn = databaseMeta.getFunctionAverage();
                break;
            }
            case COUNT_DISTINCT: 
            case COUNT: {
                fn = databaseMeta.getFunctionCount();
                break;
            }
            case MAXIMUM: {
                fn = databaseMeta.getFunctionMaximum();
                break;
            }
            case MINIMUM: {
                fn = databaseMeta.getFunctionMinimum();
                break;
            }
            case SUM: {
                fn = databaseMeta.getFunctionSum();
                break;
            }
        }
        return fn;
    }

    protected String getJoin(LogicalModel businessModel, LogicalRelationship relation, Map<LogicalTable, String> tableAliases, Map<String, Object> parameters, boolean genAsPreparedStatement, DatabaseMeta databaseMeta, String locale) throws PentahoMetadataException {
        String join = "";
        if (relation.isComplex().booleanValue()) {
            try {
                SqlOpenFormula formula = new SqlOpenFormula(businessModel, databaseMeta, relation.getComplexJoin(), tableAliases, parameters, genAsPreparedStatement);
                formula.parseAndValidate();
                join = formula.generateSQL(locale);
            }
            catch (PentahoMetadataException e) {
                logger.warn((Object)Messages.getErrorString("SqlGenerator.ERROR_0017_FAILED_TO_PARSE_COMPLEX_JOIN", relation.getComplexJoin()), (Throwable)e);
                join = relation.getComplexJoin();
            }
        } else if (relation.getFromTable() != null && relation.getToTable() != null && relation.getFromColumn() != null && relation.getToColumn() != null) {
            String leftTableAlias = null;
            leftTableAlias = tableAliases != null ? tableAliases.get(relation.getFromColumn().getLogicalTable()) : relation.getFromColumn().getLogicalTable().getId();
            join = databaseMeta.quoteField(leftTableAlias);
            join = join + ".";
            join = join + databaseMeta.quoteField((String)relation.getFromColumn().getProperty("target_column"));
            join = join + " = ";
            String rightTableAlias = null;
            rightTableAlias = tableAliases != null ? tableAliases.get(relation.getToColumn().getLogicalTable()) : relation.getToColumn().getLogicalTable().getId();
            join = join + databaseMeta.quoteField(rightTableAlias);
            join = join + ".";
            join = join + databaseMeta.quoteField((String)relation.getToColumn().getProperty("target_column"));
        } else {
            throw new PentahoMetadataException(Messages.getErrorString("SqlGenerator.ERROR_0003_INVALID_RELATION", relation.toString()));
        }
        return join;
    }

    protected class BusinessTableNeighbours
    implements Comparable<BusinessTableNeighbours> {
        public LogicalTable businessTable;
        public int nrNeighbours;

        protected BusinessTableNeighbours() {
        }

        @Override
        public int compareTo(BusinessTableNeighbours obj) {
            if (this.nrNeighbours == obj.nrNeighbours) {
                return this.businessTable.getId().compareTo(obj.businessTable.getId());
            }
            return new Integer(this.nrNeighbours).compareTo(new Integer(obj.nrNeighbours));
        }
    }
}

