/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.amrmproxy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContextValidator;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.AbstractAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.UnknownSubclusterException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class BroadcastAMRMProxyPolicy
extends AbstractAMRMProxyPolicy {
    private Set<SubClusterId> knownClusterIds = new HashSet<SubClusterId>();

    @Override
    public void reinitialize(FederationPolicyInitializationContext policyContext) throws FederationPolicyInitializationException {
        FederationPolicyInitializationContextValidator.validate(policyContext, this.getClass().getCanonicalName());
        this.setPolicyContext(policyContext);
    }

    @Override
    public Map<SubClusterId, List<ResourceRequest>> splitResourceRequests(List<ResourceRequest> resourceRequests) throws YarnException {
        Map<SubClusterId, SubClusterInfo> activeSubclusters = this.getActiveSubclusters();
        HashMap<SubClusterId, List<ResourceRequest>> answer = new HashMap<SubClusterId, List<ResourceRequest>>();
        for (SubClusterId subClusterId : activeSubclusters.keySet()) {
            answer.put(subClusterId, resourceRequests);
            this.knownClusterIds.add(subClusterId);
        }
        return answer;
    }

    @Override
    public void notifyOfResponse(SubClusterId subClusterId, AllocateResponse response) throws YarnException {
        if (!this.knownClusterIds.contains(subClusterId)) {
            throw new UnknownSubclusterException("The response is received from a subcluster that is unknown to this policy.");
        }
    }
}

