/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RemoteNode
implements Comparable<RemoteNode> {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static RemoteNode newInstance(NodeId nodeId, String httpAddress) {
        RemoteNode remoteNode = (RemoteNode)Records.newRecord(RemoteNode.class);
        remoteNode.setNodeId(nodeId);
        remoteNode.setHttpAddress(httpAddress);
        return remoteNode;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static RemoteNode newInstance(NodeId nodeId, String httpAddress, String rackName) {
        RemoteNode remoteNode = (RemoteNode)Records.newRecord(RemoteNode.class);
        remoteNode.setNodeId(nodeId);
        remoteNode.setHttpAddress(httpAddress);
        remoteNode.setRackName(rackName);
        return remoteNode;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract NodeId getNodeId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeId(NodeId var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract String getHttpAddress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setHttpAddress(String var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract String getRackName();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setRackName(String var1);

    @Override
    public int compareTo(RemoteNode other) {
        return this.getNodeId().compareTo(other.getNodeId());
    }

    public String toString() {
        return "RemoteNode{nodeId=" + this.getNodeId() + ", rackName=" + this.getRackName() + ", httpAddress=" + this.getHttpAddress() + "}";
    }
}

