/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import org.pentaho.reporting.engine.classic.core.elementfactory.TextElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.AbstractTextElementReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.SAXException;

public class StringFieldReadHandler
extends AbstractTextElementReadHandler {
    private TextFieldElementFactory textFieldElementFactory;

    public StringFieldReadHandler() {
        this.textFieldElementFactory = new TextFieldElementFactory();
    }

    protected StringFieldReadHandler(TextFieldElementFactory textFieldElementFactory) {
        this.textFieldElementFactory = textFieldElementFactory;
    }

    @Override
    protected void startParsing(PropertyAttributes atts) throws SAXException {
        super.startParsing(atts);
        this.textFieldElementFactory.setNullString(atts.getValue(this.getUri(), "nullstring"));
        String fieldName = atts.getValue(this.getUri(), "fieldname");
        if (fieldName != null) {
            this.textFieldElementFactory.setFieldname(fieldName);
        } else {
            String formula = atts.getValue(this.getUri(), "formula");
            if (formula == null) {
                throw new ParseException("Either 'fieldname' or 'formula' attribute must be given.", this.getLocator());
            }
            this.textFieldElementFactory.setFormula(formula);
        }
    }

    @Override
    protected TextElementFactory getTextElementFactory() {
        return this.textFieldElementFactory;
    }
}

