/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.libraries.base.config.Configuration;

public abstract class ClassFactoryImpl
implements ClassFactory {
    private HashMap classes = new HashMap();
    private Configuration config;

    protected ClassFactoryImpl() {
    }

    @Override
    public ObjectDescription getDescriptionForClass(Class c) {
        ObjectDescription od = (ObjectDescription)this.classes.get(c);
        if (od == null) {
            return null;
        }
        return od.getInstance();
    }

    @Override
    public ObjectDescription getSuperClassObjectDescription(Class d, ObjectDescription knownSuperClass) {
        if (d == null) {
            throw new NullPointerException("Description class must not be null.");
        }
        for (Class keyClass : this.classes.keySet()) {
            if (!keyClass.isAssignableFrom(d)) continue;
            ObjectDescription od = (ObjectDescription)this.classes.get(keyClass);
            if (knownSuperClass == null) {
                knownSuperClass = od;
                continue;
            }
            if (!knownSuperClass.getObjectClass().isAssignableFrom(od.getObjectClass())) continue;
            knownSuperClass = od;
        }
        if (knownSuperClass == null) {
            return null;
        }
        return knownSuperClass.getInstance();
    }

    protected void registerClass(Class key, ObjectDescription od) {
        this.classes.put(key, od);
        if (this.config != null) {
            od.configure(this.config);
        }
    }

    @Override
    public Iterator getRegisteredClasses() {
        return this.classes.keySet().iterator();
    }

    @Override
    public void configure(Configuration config) {
        if (config == null) {
            throw new NullPointerException("The given configuration is null");
        }
        if (this.config != null) {
            return;
        }
        this.config = config;
        for (ObjectDescription od : this.classes.values()) {
            od.configure(config);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassFactoryImpl)) {
            return false;
        }
        ClassFactoryImpl classFactory = (ClassFactoryImpl)o;
        return this.classes.equals(classFactory.classes);
    }

    @Override
    public int hashCode() {
        return this.classes.hashCode();
    }
}

