/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CustomPageDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.BundleElementRegistry;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleElementWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandlerRegistry;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.ExpressionWriterUtility;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.StyleWriterUtility;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleRule;
import org.pentaho.reporting.engine.classic.core.style.css.StyleSheetParserUtil;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceCollection;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StyleFileWriter
implements BundleWriterHandler {
    @Override
    public int getProcessingOrder() {
        return 100000;
    }

    @Override
    public String writeReport(WriteableDocumentBundle bundle, BundleWriterState state) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        BundleWriterState styleFileState = new BundleWriterState(state, "styles.xml");
        BufferedOutputStream outputStream = new BufferedOutputStream(bundle.createEntry(styleFileState.getFileName(), "text/xml"));
        DefaultTagDescription tagDescription = BundleWriterHandlerRegistry.getInstance().createWriterTagDescription();
        XmlWriter writer = new XmlWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        writer.writeXmlDeclaration("UTF-8");
        AttributeList rootAttributes = new AttributeList();
        rootAttributes.addNamespaceDeclaration("", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0");
        rootAttributes.addNamespaceDeclaration("layout", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0");
        rootAttributes.addNamespaceDeclaration("core", "http://reporting.pentaho.org/namespaces/engine/attributes/core");
        rootAttributes.addNamespaceDeclaration("html", "http://reporting.pentaho.org/namespaces/engine/attributes/html");
        rootAttributes.addNamespaceDeclaration("swing", "http://reporting.pentaho.org/namespaces/engine/attributes/swing");
        rootAttributes.addNamespaceDeclaration("pdf", "http://reporting.pentaho.org/namespaces/engine/attributes/pdf");
        rootAttributes.addNamespaceDeclaration("designtime", "http://reporting.pentaho.org/namespaces/report-designer/2.0");
        rootAttributes.addNamespaceDeclaration("crosstab", "http://reporting.pentaho.org/namespaces/engine/attributes/crosstab");
        rootAttributes.addNamespaceDeclaration("pentaho", "http://reporting.pentaho.org/namespaces/engine/attributes/pentaho");
        rootAttributes.addNamespaceDeclaration("table", "http://reporting.pentaho.org/namespaces/engine/attributes/table");
        rootAttributes.addNamespaceDeclaration("page", "http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext");
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "style", rootAttributes, false);
        AbstractReportDefinition report = styleFileState.getReport();
        if (report instanceof MasterReport) {
            PageDefinition definition = report.getPageDefinition();
            StyleFileWriter.writePageDefinition(writer, definition);
            MasterReport master = (MasterReport)report;
            ElementStyleDefinition styleDefinition = master.getStyleDefinition();
            if (styleDefinition != null) {
                writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "style-definition", false);
                StyleFileWriter.writeStyleDefinition(writer, styleDefinition);
                writer.writeCloseTag();
            }
        }
        if (ExpressionWriterUtility.isGlobalLayoutExpressionActive(styleFileState)) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "layout-processors", false);
            ExpressionWriterUtility.writeGlobalLayoutExpressions(bundle, styleFileState, writer);
            writer.writeCloseTag();
        }
        Watermark watermark = report.getWatermark();
        BundleElementWriteHandler watermarkHandler = BundleElementRegistry.getInstance().getWriteHandler(watermark);
        watermarkHandler.writeElement(bundle, styleFileState, writer, watermark);
        PageHeader pageHeader = report.getPageHeader();
        BundleElementWriteHandler pageHeaderHandler = BundleElementRegistry.getInstance().getWriteHandler(pageHeader);
        pageHeaderHandler.writeElement(bundle, styleFileState, writer, pageHeader);
        PageFooter pageFooter = report.getPageFooter();
        BundleElementWriteHandler pageFooterHandler = BundleElementRegistry.getInstance().getWriteHandler(pageFooter);
        pageFooterHandler.writeElement(bundle, styleFileState, writer, pageFooter);
        writer.writeCloseTag();
        writer.close();
        return styleFileState.getFileName();
    }

    public static void writeStyleDefinition(XmlWriter writer, ElementStyleDefinition styleDefinition) throws IOException {
        int styleSheetCount = styleDefinition.getStyleSheetCount();
        for (int s = 0; s < styleSheetCount; ++s) {
            ElementStyleDefinition child = styleDefinition.getStyleSheet(s);
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "style-definition", false);
            StyleFileWriter.writeStyleDefinition(writer, child);
            writer.writeCloseTag();
        }
        int ruleCount = styleDefinition.getRuleCount();
        for (int r = 0; r < ruleCount; ++r) {
            ElementStyleSheet rule = styleDefinition.getRule(r);
            if (!(rule instanceof ElementStyleRule)) continue;
            ElementStyleRule styleRule = (ElementStyleRule)rule;
            StyleFileWriter.writeStyleRule(writer, styleRule);
        }
    }

    private static void writeStyleRule(XmlWriter writer, ElementStyleRule styleRule) throws IOException {
        if (styleRule.getSelectorCount() == 0 && styleRule.getDefinedPropertyNamesArray().length == 0) {
            return;
        }
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "rule", false);
        NamespaceCollection collection = StyleSheetParserUtil.getInstance().getNamespaceCollection();
        for (int i = 0; i < styleRule.getSelectorCount(); ++i) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "selector", false);
            writer.writeTextNormalized(styleRule.getSelector(i).print(collection), false);
            writer.writeCloseTag();
        }
        StyleWriterUtility.writeStyleRule("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "styles", writer, styleRule);
        writer.writeCloseTag();
    }

    private static void writePageDefinition(XmlWriter writer, PageDefinition definition) throws BundleWriterException, IOException {
        if (writer == null) {
            throw new NullPointerException();
        }
        if (definition == null) {
            throw new NullPointerException();
        }
        if (!(definition instanceof SimplePageDefinition)) {
            if (definition instanceof CustomPageDefinition) {
                throw new BundleWriterException("Cannot handle 'CustomPageDefinition' objects.");
            }
            throw new BundleWriterException("Cannot handle generic page-definition objects.");
        }
        SimplePageDefinition sdef = (SimplePageDefinition)definition;
        int pageCountHorizontal = sdef.getPageCountHorizontal();
        int pageCountVertical = sdef.getPageCountVertical();
        PageFormat pageFormat = sdef.getPageFormat();
        AttributeList attr = new AttributeList();
        attr.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "horizontal-span", String.valueOf(pageCountHorizontal));
        attr.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "vertical-span", String.valueOf(pageCountVertical));
        StyleFileWriter.buildPageFormatProperties(pageFormat, attr);
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "page-definition", attr, true);
    }

    private static AttributeList buildPageFormatProperties(PageFormat fmt, AttributeList retval) {
        if (fmt == null) {
            throw new NullPointerException();
        }
        if (retval == null) {
            throw new NullPointerException();
        }
        Paper paper = fmt.getPaper();
        int w = (int)paper.getWidth();
        int h = (int)paper.getHeight();
        String pageDefinition = PageFormatFactory.getInstance().getPageFormatName(w, h);
        if (pageDefinition != null) {
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "pageformat", pageDefinition);
        } else {
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "width", String.valueOf(w));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "height", String.valueOf(h));
        }
        Insets borders = StyleFileWriter.getBorders(paper);
        if (fmt.getOrientation() == 2) {
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "orientation", "reverse-landscape");
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-top", String.valueOf(borders.right));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-left", String.valueOf(borders.top));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-bottom", String.valueOf(borders.left));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-right", String.valueOf(borders.bottom));
        } else if (fmt.getOrientation() == 1) {
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "orientation", "portrait");
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-top", String.valueOf(borders.top));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-left", String.valueOf(borders.left));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-bottom", String.valueOf(borders.bottom));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-right", String.valueOf(borders.right));
        } else {
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "orientation", "landscape");
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-top", String.valueOf(borders.left));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-left", String.valueOf(borders.bottom));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-bottom", String.valueOf(borders.right));
            retval.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "margin-right", String.valueOf(borders.top));
        }
        return retval;
    }

    private static Insets getBorders(Paper p) {
        return new Insets((int)p.getImageableY(), (int)p.getImageableX(), (int)(p.getHeight() - (p.getImageableY() + p.getImageableHeight())), (int)(p.getWidth() - (p.getImageableX() + p.getImageableWidth())));
    }
}

