/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.MasterReportType;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ExcelOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public static final int PAGINATION_NONE = 0;
    public static final int PAGINATION_MANUAL = 1;
    public static final int PAGINATION_FULL = 2;
    private int paginationMode;

    public ExcelOutputProcessorMetaData(int paginationMode) {
        this.paginationMode = paginationMode;
    }

    @Override
    public void initialize(Configuration configuration) {
        ExtendedConfigurationWrapper extendedConfig;
        double deviceResolution;
        String emulatePadding;
        super.initialize(configuration);
        String localStrict = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.StrictLayout");
        if (localStrict != null) {
            if ("true".equals(localStrict)) {
                this.addFeature(AbstractTableOutputProcessor.STRICT_LAYOUT);
            }
        } else {
            String globalStrict = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.StrictLayout");
            if ("true".equals(globalStrict)) {
                this.addFeature(AbstractTableOutputProcessor.STRICT_LAYOUT);
            }
        }
        if (!"true".equals(emulatePadding = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.EmulateCellPadding"))) {
            this.addFeature(OutputProcessorFeature.DISABLE_PADDING);
        } else {
            this.addFeature(OutputProcessorFeature.EMULATE_PADDING);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.UsePageBands"))) {
            this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.UsePageBands"))) {
            this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.TreatEllipseAsRectangle"))) {
            this.addFeature(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.TreatEllipseAsRectangle"))) {
            this.addFeature(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE);
        }
        if (this.paginationMode == 2) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
        } else if (this.paginationMode == 1) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
            this.addFeature(OutputProcessorFeature.ITERATIVE_RENDERING);
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        } else {
            this.addFeature(OutputProcessorFeature.ITERATIVE_RENDERING);
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.ShapeAsContent"))) {
            this.addFeature(AbstractTableOutputProcessor.SHAPES_CONTENT);
        }
        if ((deviceResolution = (double)(extendedConfig = new ExtendedConfigurationWrapper(configuration)).getIntProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.DeviceResolution", 0)) > 0.0) {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, deviceResolution);
        }
    }

    @Override
    public String getExportDescriptor() {
        return "table/excel";
    }

    @Override
    public boolean isExtraContentElement(StyleSheet style, ReportAttributeMap attributes) {
        if (!this.isFeatureSupported(OutputProcessorFeature.DETECT_EXTRA_CONTENT)) {
            return false;
        }
        Object o = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
        if (o instanceof MasterReportType) {
            return false;
        }
        if (super.isExtraContentElement(style, attributes)) {
            return true;
        }
        return !StringUtils.isEmpty((String)((String)attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "formula")));
    }

    @Override
    protected boolean getAutoCorrectFontMetrics() {
        return true;
    }
}

