/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.validator;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.AbstractStructureVisitor;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.HashNMap;

public class DynamicStyleRootBandAnalyzer
extends AbstractStructureVisitor {
    private HashNMap<InstanceID, StyleKey> dynamicTemplateInfo;
    private HashNMap<String, StyleKey> styleByElementName;

    public DynamicStyleRootBandAnalyzer(HashNMap<String, StyleKey> styleByElementName, HashNMap<InstanceID, StyleKey> styleById) {
        this.styleByElementName = styleByElementName;
        this.dynamicTemplateInfo = new HashNMap();
        for (InstanceID id : styleById.keySet()) {
            Iterator it = styleById.getAll((Object)id);
            while (it.hasNext()) {
                this.dynamicTemplateInfo.put((Object)id, it.next());
            }
        }
    }

    public void compute(Section rootLevelBand) {
        this.dynamicTemplateInfo.clear();
        this.inspectElement(rootLevelBand);
        this.traverseSection(rootLevelBand);
        HashMap<InstanceID, StyleKey[]> stash = this.buildStash();
        rootLevelBand.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "fast-export-dynamic-style-stash", stash);
    }

    private HashMap<InstanceID, StyleKey[]> buildStash() {
        HashMap<InstanceID, StyleKey[]> stash = new HashMap<InstanceID, StyleKey[]>();
        for (InstanceID id : this.dynamicTemplateInfo.keySet()) {
            int valueCount = this.dynamicTemplateInfo.getValueCount((Object)id);
            StyleKey[] styleKeys = (StyleKey[])this.dynamicTemplateInfo.toArray((Object)id, (Object[])new StyleKey[valueCount]);
            stash.put(id, styleKeys);
        }
        return stash;
    }

    @Override
    protected void traverseSection(Section section) {
        this.traverseSectionWithoutSubReports(section);
    }

    @Override
    protected void inspectElement(ReportElement element) {
        this.dynamicTemplateInfo.add((Object)element.getObjectID(), (Object)ElementStyleKeys.VISIBLE);
        String name = element.getName();
        if (this.styleByElementName.containsKey((Object)name)) {
            Iterator it = this.styleByElementName.getAll((Object)name);
            while (it.hasNext()) {
                this.dynamicTemplateInfo.put((Object)element.getObjectID(), it.next());
            }
        }
        this.traverseStyleExpressions(element);
    }

    @Override
    protected void inspectStyleExpression(ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
        this.dynamicTemplateInfo.add((Object)element.getObjectID(), (Object)styleKey);
    }
}

