/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.template;

import java.io.IOException;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.FastExportTemplate;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.DynamicStyleKey;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastExportTemplateProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastSheetLayoutProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.TemplatingOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;

public abstract class AbstractContentProducerTemplate
implements FastExportTemplate {
    private SheetLayout sharedSheetLayout;
    private OutputProcessorMetaData metaData;
    private HashMap<DynamicStyleKey, FormattedDataBuilder> bandFormatter;

    public AbstractContentProducerTemplate(SheetLayout sharedSheetLayout) {
        this.sharedSheetLayout = sharedSheetLayout;
        this.bandFormatter = new HashMap();
    }

    protected OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    protected SheetLayout getSharedSheetLayout() {
        return this.sharedSheetLayout;
    }

    @Override
    public void write(Band band, ExpressionRuntime runtime) throws InvalidReportStateException {
        try {
            DynamicStyleKey dynamicStyleKey = DynamicStyleKey.create(band, runtime);
            FormattedDataBuilder messageFormatSupport = this.bandFormatter.get(dynamicStyleKey);
            if (messageFormatSupport == null) {
                messageFormatSupport = this.createTemplate(band, runtime);
                this.bandFormatter.put(dynamicStyleKey, messageFormatSupport);
            }
            this.writeContent(band, runtime, messageFormatSupport);
        }
        catch (IOException e) {
            throw new InvalidReportStateException("Failed to write content", e);
        }
        catch (ContentProcessingException e) {
            throw new InvalidReportStateException("Failed to write content", e);
        }
        catch (ReportProcessingException e) {
            throw new InvalidReportStateException("Failed to write content", e);
        }
    }

    @Override
    public void finishReport() throws ReportProcessingException {
    }

    protected abstract void writeContent(Band var1, ExpressionRuntime var2, FormattedDataBuilder var3) throws IOException, ReportProcessingException, ContentProcessingException;

    @Override
    public void initialize(ReportDefinition report, ExpressionRuntime runtime, boolean pagination) {
        this.metaData = runtime.getProcessingContext().getOutputProcessorMetaData();
    }

    protected FormattedDataBuilder createTemplate(Band band, ExpressionRuntime runtime) throws ReportProcessingException, ContentProcessingException {
        FastExportTemplateProducer templateListener = this.createTemplateProducer();
        TemplatingOutputProcessor op = new TemplatingOutputProcessor(runtime.getProcessingContext().getOutputProcessorMetaData(), templateListener);
        FastSheetLayoutProducer.performLayout(band, runtime, op);
        return templateListener.createDataBuilder();
    }

    protected abstract FastExportTemplateProducer createTemplateProducer();
}

