/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base;

import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigStorage;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.NullConfigStorage;

public final class ConfigFactory {
    public static final String CONFIG_TARGET_KEY = "org.pentaho.reporting.engine.classic.core.ConfigStore";
    private static ConfigFactory factory;
    private ConfigStorage userStorage;
    private ConfigStorage systemStorage;

    public static synchronized ConfigFactory getInstance() {
        if (factory == null) {
            factory = new ConfigFactory();
            factory.defineSystemStorage(new NullConfigStorage());
            factory.defineUserStorage(new NullConfigStorage());
        }
        return factory;
    }

    private ConfigFactory() {
    }

    public void defineUserStorage(ConfigStorage storage) {
        if (storage == null) {
            throw new NullPointerException();
        }
        this.userStorage = storage;
    }

    public void defineSystemStorage(ConfigStorage storage) {
        if (storage == null) {
            throw new NullPointerException();
        }
        this.systemStorage = storage;
    }

    public ConfigStorage getUserStorage() {
        return this.userStorage;
    }

    public ConfigStorage getSystemStorage() {
        return this.systemStorage;
    }

    public static boolean isValidPath(String path) {
        char[] data = path.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (Character.isJavaIdentifierPart(data[i])) continue;
            return false;
        }
        return true;
    }

    public static String encodePath(String path) {
        char[] data = path.toCharArray();
        StringBuffer encoded = new StringBuffer(path.length());
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == '$') {
                encoded.append('$');
                encoded.append('$');
                continue;
            }
            if (!Character.isJavaIdentifierPart(data[i])) {
                encoded.append('$');
                String hex = Integer.toHexString(data[i]);
                for (int x = hex.length(); x < 4; ++x) {
                    encoded.append('0');
                }
                encoded.append(hex);
                continue;
            }
            encoded.append(data[i]);
        }
        return encoded.toString();
    }
}

