/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ResourceReference;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.engine.classic.core.metadata.builder.ReportPreProcessorPropertyMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.propertyeditors.SharedPropertyDescriptorProxy;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultReportPreProcessorPropertyMetaData
extends AbstractMetaData
implements ReportPreProcessorPropertyMetaData {
    private static final Log logger = LogFactory.getLog(DefaultReportPreProcessorPropertyMetaData.class);
    private boolean mandatory;
    private String propertyRole;
    private boolean computed;
    private ReportPreProcessorPropertyCore reportPreProcessorCore;
    private SharedPropertyDescriptorProxy propertyDescriptor;
    private Class<? extends PropertyEditor> propertyEditorClass;

    public DefaultReportPreProcessorPropertyMetaData(String name, String bundleLocation, boolean expert, boolean preferred, boolean hidden, boolean deprecated, boolean mandatory, boolean computed, String propertyRole, SharedBeanInfo beanInfo, String propertyEditorClass, ReportPreProcessorPropertyCore reportPreProcessorCore, MaturityLevel maturityLevel, int compatibilityLevel) {
        super(name, bundleLocation, "property.", expert, preferred, hidden, deprecated, maturityLevel, compatibilityLevel);
        ArgumentNullException.validate((String)"propertyRole", (Object)propertyRole);
        ArgumentNullException.validate((String)"beanInfo", (Object)beanInfo);
        ArgumentNullException.validate((String)"reportPreProcessorCore", (Object)reportPreProcessorCore);
        this.propertyDescriptor = new SharedPropertyDescriptorProxy(beanInfo, name);
        this.reportPreProcessorCore = reportPreProcessorCore;
        this.computed = computed;
        this.propertyEditorClass = ObjectUtilities.loadAndValidate((String)propertyEditorClass, DefaultExpressionPropertyMetaData.class, PropertyEditor.class);
        this.mandatory = mandatory;
        this.propertyRole = propertyRole;
    }

    public DefaultReportPreProcessorPropertyMetaData(ReportPreProcessorPropertyMetaDataBuilder builder) {
        super(builder);
        this.propertyDescriptor = builder.getDescriptor();
        this.computed = builder.isComputed();
        this.reportPreProcessorCore = builder.getCore();
        this.propertyEditorClass = builder.getEditor();
        this.mandatory = builder.isMandatory();
        this.propertyRole = builder.getValueRole();
        ArgumentNullException.validate((String)"propertyRole", (Object)this.propertyRole);
        ArgumentNullException.validate((String)"propertyDescriptor", (Object)this.propertyDescriptor);
        ArgumentNullException.validate((String)"reportPreProcessorCore", (Object)this.reportPreProcessorCore);
    }

    @Override
    public boolean isComputed() {
        return this.computed;
    }

    @Override
    public Class getPropertyType() {
        return this.getBeanDescriptor().getPropertyType();
    }

    @Override
    public String getPropertyRole() {
        return this.propertyRole;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public String[] getReferencedFields(Expression element, Object attributeValue) {
        return this.reportPreProcessorCore.getReferencedFields(this, element, attributeValue);
    }

    @Override
    public String[] getReferencedGroups(Expression element, Object attributeValue) {
        return this.reportPreProcessorCore.getReferencedGroups(this, element, attributeValue);
    }

    @Override
    public String[] getReferencedElements(Expression expression, Object attributeValue) {
        return this.reportPreProcessorCore.getReferencedElements(this, expression, attributeValue);
    }

    @Override
    public ResourceReference[] getReferencedResources(Expression expression, Object attributeValue, Element reportElement, ResourceManager resourceManager) {
        return this.reportPreProcessorCore.getReferencedResources(this, expression, attributeValue, reportElement, resourceManager);
    }

    @Override
    public PropertyDescriptor getBeanDescriptor() {
        return this.propertyDescriptor.get();
    }

    @Override
    public PropertyEditor getEditor() {
        if (this.propertyEditorClass == null) {
            return null;
        }
        try {
            return this.propertyEditorClass.newInstance();
        }
        catch (Exception e) {
            logger.warn((Object)("Property editor for expression property '" + this.getName() + "' threw an Exception on instantiate"), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getExtraCalculationFields() {
        return this.reportPreProcessorCore.getExtraCalculationFields(this);
    }
}

