/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.text;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.SpacerRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.engine.classic.core.layout.text.GlyphList;
import org.pentaho.reporting.engine.classic.core.layout.text.RenderableTextFactory;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.text.DefaultLanguageClassifier;
import org.pentaho.reporting.libraries.fonts.text.GraphemeClusterProducer;
import org.pentaho.reporting.libraries.fonts.text.LanguageClassifier;
import org.pentaho.reporting.libraries.fonts.text.Spacing;
import org.pentaho.reporting.libraries.fonts.text.SpacingProducer;
import org.pentaho.reporting.libraries.fonts.text.StaticSpacingProducer;
import org.pentaho.reporting.libraries.fonts.text.breaks.BreakOpportunityProducer;
import org.pentaho.reporting.libraries.fonts.text.breaks.LineBreakProducer;
import org.pentaho.reporting.libraries.fonts.text.breaks.WordBreakProducer;
import org.pentaho.reporting.libraries.fonts.text.classifier.GlyphClassificationProducer;
import org.pentaho.reporting.libraries.fonts.text.classifier.WhitespaceClassificationProducer;
import org.pentaho.reporting.libraries.fonts.text.font.FontSizeProducer;
import org.pentaho.reporting.libraries.fonts.text.font.GlyphMetrics;
import org.pentaho.reporting.libraries.fonts.text.font.KerningProducer;
import org.pentaho.reporting.libraries.fonts.text.font.NoKerningProducer;
import org.pentaho.reporting.libraries.fonts.text.font.VariableFontSizeProducer;
import org.pentaho.reporting.libraries.fonts.text.whitespace.CollapseWhiteSpaceFilter;
import org.pentaho.reporting.libraries.fonts.text.whitespace.DiscardWhiteSpaceFilter;
import org.pentaho.reporting.libraries.fonts.text.whitespace.PreserveBreaksWhiteSpaceFilter;
import org.pentaho.reporting.libraries.fonts.text.whitespace.PreserveWhiteSpaceFilter;
import org.pentaho.reporting.libraries.fonts.text.whitespace.WhiteSpaceFilter;
import org.pentaho.reporting.libraries.fonts.tools.FontStrictGeomUtility;

public final class DefaultRenderableTextFactory
implements RenderableTextFactory {
    private static final RenderNode[] EMPTY_RENDER_NODE = new RenderNode[0];
    private static final RenderableText[] EMPTY_TEXT = new RenderableText[0];
    private static final GlyphList EMPTY_GLYPHS = new GlyphList(1).lock();
    private static final int[] END_OF_TEXT = new int[]{Integer.MAX_VALUE};
    private GraphemeClusterProducer clusterProducer;
    private boolean startText;
    private FontSizeProducer fontSizeProducer;
    private KerningProducer kerningProducer;
    private SpacingProducer spacingProducer;
    private Spacing spacingProducerKey;
    private BreakOpportunityProducer breakOpportunityProducer;
    private WhiteSpaceFilter whitespaceFilter;
    private GlyphClassificationProducer classificationProducer;
    private StyleSheet layoutContext;
    private LanguageClassifier languageClassifier;
    private transient GlyphMetrics dims;
    private ArrayList<RenderNode> words;
    private GlyphList glyphList;
    private long leadingMargin;
    private int spaceCount;
    private int lastLanguage;
    private transient FontMetrics fontMetrics;
    private OutputProcessorMetaData metaData;
    private NoKerningProducer noKerningProducer;
    private WhitespaceCollapse whitespaceFilterValue;
    private WhitespaceCollapse whitespaceCollapseValue;
    private TextWrap breakOpportunityValue;
    private long wordSpacing;
    private ReportAttributeMap<Object> attributeMap;
    private ElementType elementType;
    private ExtendedBaselineInfo uniformBaselineInfo;
    private InstanceID instanceId;

    public DefaultRenderableTextFactory(OutputProcessorMetaData metaData) {
        this.metaData = metaData;
        this.clusterProducer = new GraphemeClusterProducer();
        this.languageClassifier = new DefaultLanguageClassifier();
        this.startText = true;
        this.words = new ArrayList(20);
        this.dims = new GlyphMetrics();
        this.noKerningProducer = new NoKerningProducer();
        this.spacingProducer = new StaticSpacingProducer(Spacing.EMPTY_SPACING);
        this.spacingProducerKey = Spacing.EMPTY_SPACING;
        this.glyphList = new GlyphList(100);
    }

    @Override
    public RenderNode[] createText(int[] text, int offset, int length, StyleSheet layoutContext, ElementType elementType, InstanceID instanceId, ReportAttributeMap<Object> attributeMap) {
        this.instanceId = instanceId;
        if (layoutContext == null) {
            throw new NullPointerException();
        }
        if (attributeMap == null) {
            throw new NullPointerException();
        }
        if (elementType == null) {
            throw new NullPointerException();
        }
        if (text == null) {
            throw new NullPointerException();
        }
        this.layoutContext = layoutContext;
        this.elementType = elementType;
        this.attributeMap = attributeMap;
        this.fontMetrics = this.metaData.getFontMetrics(layoutContext);
        this.uniformBaselineInfo = null;
        this.kerningProducer = this.createKerningProducer(layoutContext);
        this.fontSizeProducer = this.createFontSizeProducer(layoutContext);
        this.spacingProducer = this.createSpacingProducer(layoutContext);
        this.breakOpportunityProducer = this.createBreakProducer(layoutContext);
        this.whitespaceFilter = this.createWhitespaceFilter(layoutContext);
        this.classificationProducer = this.createGlyphClassifier(layoutContext);
        this.layoutContext = layoutContext;
        this.wordSpacing = this.metaData.isFeatureSupported(OutputProcessorFeature.SPACING_SUPPORTED) ? FontStrictGeomUtility.toInternalValue((double)layoutContext.getDoubleStyleProperty(TextStyleKeys.WORD_SPACING, 0.0)) : 0L;
        if (this.startText) {
            this.whitespaceFilter.filter(Integer.MIN_VALUE);
            this.breakOpportunityProducer.createBreakOpportunity(Integer.MIN_VALUE);
            this.kerningProducer.getKerning(Integer.MIN_VALUE);
            this.startText = false;
        }
        return this.processText(text, offset, length);
    }

    protected RenderNode[] processText(int[] text, int offset, int length) {
        int maxLen = Math.min(length + offset, text.length);
        int clusterStartIdx = offset < maxLen ? 0 : -1;
        for (int i = offset; i < maxLen; ++i) {
            int codePoint = text[i];
            boolean clusterStarted = this.clusterProducer.createGraphemeCluster(codePoint);
            if (!clusterStarted) continue;
            if (i > offset) {
                int extraCharLength = i - clusterStartIdx - 1;
                this.addGlyph(text, clusterStartIdx, extraCharLength);
            }
            clusterStartIdx = i;
        }
        if (clusterStartIdx >= offset) {
            int extraCharLength = maxLen - clusterStartIdx - 1;
            this.addGlyph(text, clusterStartIdx, extraCharLength);
        }
        if (!this.words.isEmpty()) {
            RenderNode[] renderableTexts = this.words.toArray(new RenderNode[this.words.size()]);
            this.words.clear();
            return renderableTexts;
        }
        return EMPTY_RENDER_NODE;
    }

    protected void addGlyph(int[] text, int offset, int extraCharCount) {
        boolean forceLinebreak;
        int rawCodePoint = text[offset];
        if (rawCodePoint == Integer.MAX_VALUE) {
            this.whitespaceFilter.filter(rawCodePoint);
            this.classificationProducer.getClassification(rawCodePoint);
            this.kerningProducer.getKerning(rawCodePoint);
            this.breakOpportunityProducer.createBreakOpportunity(rawCodePoint);
            this.spacingProducer.createSpacing(rawCodePoint);
            this.fontSizeProducer.getCharacterSize(rawCodePoint, this.dims);
            if (this.leadingMargin > 0L || this.glyphList.getSize() != 0) {
                this.addWord(false);
            } else {
                this.glyphList.clear();
                this.leadingMargin = 0L;
                this.spaceCount = 0;
            }
            return;
        }
        int codePoint = this.whitespaceFilter.filter(rawCodePoint);
        if (codePoint == -1) {
            if (extraCharCount == 0) {
                return;
            }
            codePoint = 8203;
        }
        int glyphClassification = this.classificationProducer.getClassification(codePoint);
        long kerning = this.kerningProducer.getKerning(codePoint);
        int breakweight = this.breakOpportunityProducer.createBreakOpportunity(codePoint);
        Spacing spacing = this.spacingProducer.createSpacing(codePoint);
        this.dims = this.fontSizeProducer.getCharacterSize(codePoint, this.dims);
        int width = this.dims.getWidth();
        int height = this.dims.getHeight();
        this.lastLanguage = this.languageClassifier.getScript(codePoint);
        for (int i = 0; i < extraCharCount; ++i) {
            int extraChar = text[offset + i + 1];
            this.dims = this.fontSizeProducer.getCharacterSize(extraChar, this.dims);
            width = Math.max(width, this.dims.getWidth() & Integer.MAX_VALUE);
            height = Math.max(height, this.dims.getHeight() & Integer.MAX_VALUE);
            breakweight = this.breakOpportunityProducer.createBreakOpportunity(extraChar);
            glyphClassification = this.classificationProducer.getClassification(extraChar);
        }
        if (0 == glyphClassification && this.isWordBreak(breakweight)) {
            boolean bl = forceLinebreak = breakweight == 4;
            if (!this.glyphList.isEmpty() || forceLinebreak) {
                this.addWord(forceLinebreak);
                if (forceLinebreak) {
                    return;
                }
            }
            this.leadingMargin += (long)width + this.wordSpacing;
            ++this.spaceCount;
            return;
        }
        this.glyphList.addGlyphData(text, offset, extraCharCount + 1, breakweight, glyphClassification, spacing, width, height, this.dims.getBaselinePosition(), (int)kerning);
        if (this.isWordBreak(breakweight)) {
            forceLinebreak = breakweight == 4;
            this.addWord(forceLinebreak);
        }
    }

    private ExtendedBaselineInfo getBaselineInfo(int character) {
        if (this.uniformBaselineInfo != null) {
            return this.uniformBaselineInfo;
        }
        ExtendedBaselineInfo baselineInfo = this.metaData.getBaselineInfo(character, this.layoutContext);
        if (this.fontMetrics.isUniformFontMetrics()) {
            this.uniformBaselineInfo = baselineInfo;
        }
        return baselineInfo;
    }

    protected void addWord(boolean forceLinebreak) {
        if (this.glyphList.isEmpty()) {
            if (this.leadingMargin > 0L) {
                SpacerRenderNode spacer = new SpacerRenderNode(RenderableText.convert(this.leadingMargin), 0L, true, this.spaceCount);
                this.words.add(spacer);
            }
            if (forceLinebreak) {
                ExtendedBaselineInfo info = this.getBaselineInfo(10);
                RenderableText text = new RenderableText(this.layoutContext, this.elementType, this.instanceId, this.attributeMap, info, EMPTY_GLYPHS, 0, 0, this.lastLanguage, true);
                this.words.add(text);
            }
            this.leadingMargin = 0L;
            this.spaceCount = 0;
            return;
        }
        if (this.leadingMargin > 0L) {
            SpacerRenderNode spacer = new SpacerRenderNode(RenderableText.convert(this.leadingMargin), 0L, true, this.spaceCount);
            this.words.add(spacer);
        }
        int codePoint = this.glyphList.getGlyph(0).getCodepoint();
        ExtendedBaselineInfo baselineInfo = this.getBaselineInfo(codePoint);
        RenderableText text = new RenderableText(this.layoutContext, this.elementType, this.instanceId, this.attributeMap, baselineInfo, this.glyphList.lock(), 0, this.glyphList.getSize(), this.lastLanguage, forceLinebreak);
        this.words.add(text);
        this.glyphList.clear();
        this.leadingMargin = 0L;
        this.spaceCount = 0;
    }

    private boolean isWordBreak(int breakOp) {
        return 3 == breakOp || 4 == breakOp;
    }

    protected WhiteSpaceFilter createWhitespaceFilter(StyleSheet layoutContext) {
        WhitespaceCollapse wsColl = (WhitespaceCollapse)layoutContext.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        if (this.whitespaceFilter != null && ObjectUtilities.equal((Object)this.whitespaceFilterValue, (Object)wsColl)) {
            this.whitespaceFilter.reset();
            return this.whitespaceFilter;
        }
        this.whitespaceFilterValue = wsColl;
        if (WhitespaceCollapse.DISCARD.equals(wsColl)) {
            return new DiscardWhiteSpaceFilter();
        }
        if (WhitespaceCollapse.PRESERVE.equals(wsColl)) {
            return new PreserveWhiteSpaceFilter();
        }
        if (WhitespaceCollapse.PRESERVE_BREAKS.equals(wsColl)) {
            return new PreserveBreaksWhiteSpaceFilter();
        }
        return new CollapseWhiteSpaceFilter();
    }

    protected GlyphClassificationProducer createGlyphClassifier(StyleSheet layoutContext) {
        WhitespaceCollapse wsColl = (WhitespaceCollapse)layoutContext.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        if (this.classificationProducer != null && ObjectUtilities.equal((Object)this.whitespaceCollapseValue, (Object)wsColl)) {
            this.classificationProducer.reset();
            return this.classificationProducer;
        }
        this.whitespaceCollapseValue = wsColl;
        this.classificationProducer = new WhitespaceClassificationProducer();
        return this.classificationProducer;
    }

    protected BreakOpportunityProducer createBreakProducer(StyleSheet layoutContext) {
        TextWrap wordBreak = (TextWrap)layoutContext.getStyleProperty(TextStyleKeys.TEXT_WRAP);
        if (this.breakOpportunityProducer != null && ObjectUtilities.equal((Object)this.breakOpportunityValue, (Object)wordBreak)) {
            this.breakOpportunityProducer.reset();
            return this.breakOpportunityProducer;
        }
        this.breakOpportunityValue = wordBreak;
        this.breakOpportunityProducer = TextWrap.NONE.equals(wordBreak) ? new LineBreakProducer() : new WordBreakProducer();
        return this.breakOpportunityProducer;
    }

    protected SpacingProducer createSpacingProducer(StyleSheet layoutContext) {
        if (this.metaData.isFeatureSupported(OutputProcessorFeature.SPACING_SUPPORTED)) {
            double minValue = layoutContext.getDoubleStyleProperty(TextStyleKeys.X_MIN_LETTER_SPACING, 0.0);
            double optValue = layoutContext.getDoubleStyleProperty(TextStyleKeys.X_OPTIMUM_LETTER_SPACING, 0.0);
            double maxValue = layoutContext.getDoubleStyleProperty(TextStyleKeys.X_MAX_LETTER_SPACING, 0.0);
            int minIntVal = (int)StrictGeomUtility.toInternalValue(minValue);
            int optIntVal = (int)StrictGeomUtility.toInternalValue(optValue);
            int maxIntVal = (int)StrictGeomUtility.toInternalValue(maxValue);
            Spacing spacing = new Spacing(minIntVal, optIntVal, maxIntVal);
            return new StaticSpacingProducer(spacing);
        }
        Spacing spacing = Spacing.EMPTY_SPACING;
        if (this.spacingProducer != null && ObjectUtilities.equal((Object)spacing, (Object)this.spacingProducerKey)) {
            return this.spacingProducer;
        }
        this.spacingProducer = new StaticSpacingProducer(spacing);
        this.spacingProducerKey = spacing;
        return this.spacingProducer;
    }

    protected FontSizeProducer createFontSizeProducer(StyleSheet layoutContext) {
        return new VariableFontSizeProducer(this.fontMetrics);
    }

    protected KerningProducer createKerningProducer(StyleSheet layoutContext) {
        return this.noKerningProducer;
    }

    @Override
    public RenderNode[] finishText() {
        if (this.layoutContext == null) {
            return EMPTY_TEXT;
        }
        RenderNode[] text = this.processText(END_OF_TEXT, 0, 1);
        this.layoutContext = null;
        this.fontSizeProducer = null;
        this.uniformBaselineInfo = null;
        return text;
    }

    @Override
    public void startText() {
        this.startText = true;
    }
}

