/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class PageState
implements Serializable {
    private ProcessState reportState;
    private int pageCursor;
    private Boolean safeToStore;

    public PageState(ProcessState reportState, int pageCursor) {
        if (reportState == null) {
            throw new NullPointerException();
        }
        this.reportState = reportState;
        this.pageCursor = pageCursor;
    }

    public int getPageCursor() {
        return this.pageCursor;
    }

    public ProcessState getReportState() {
        return this.reportState;
    }

    public void prepareStorage() {
        this.reportState = this.reportState.deriveForStorage();
    }

    public boolean isSafeToStoreEarly() {
        if (this.reportState.getLevel() == -2 && !this.reportState.isPrepareRun()) {
            return true;
        }
        if (this.pageCursor == 0) {
            return true;
        }
        if (this.safeToStore == null) {
            OutputFunction outputFunction = this.reportState.getLayoutProcess().getOutputFunction();
            if (outputFunction instanceof DefaultOutputFunction) {
                DefaultOutputFunction defaultOutputFunction = (DefaultOutputFunction)outputFunction;
                this.safeToStore = defaultOutputFunction.getRenderer().isSafeToStore();
            } else {
                this.safeToStore = Boolean.FALSE;
            }
        }
        return this.safeToStore;
    }
}

