/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.model.AutoRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class TableRowRenderBox
extends RenderBox {
    private static final Log logger = LogFactory.getLog(TableRowRenderBox.class);
    private int rowIndex = -1;
    private boolean bodySection;

    public TableRowRenderBox() {
        this(SimpleStyleSheet.EMPTY_STYLE, new InstanceID(), BoxDefinition.EMPTY, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, null);
    }

    public TableRowRenderBox(StyleSheet styleSheet, InstanceID instanceID, BoxDefinition boxDefinition, ElementType elementType, ReportAttributeMap attributes, ReportStateKey stateKey) {
        super(0, 1, styleSheet, instanceID, boxDefinition, elementType, attributes, stateKey);
    }

    @Override
    public boolean useMinimumChunkWidth() {
        return true;
    }

    public boolean isAutoGenerated() {
        return AutoLayoutBoxType.INSTANCE == this.getElementType();
    }

    @Override
    public int getNodeType() {
        return 278530;
    }

    @Override
    public boolean isIgnorableForRendering() {
        return false;
    }

    protected void reinit(StyleSheet styleSheet, ElementType elementType, ReportAttributeMap attributes, InstanceID instanceId) {
        super.reinit(styleSheet, elementType, attributes, instanceId);
        this.rowIndex = -1;
        this.bodySection = false;
    }

    public boolean isBodySection() {
        return this.bodySection;
    }

    public void setBodySection(boolean bodySection) {
        this.bodySection = bodySection;
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @Override
    public void setCachedY(long cachedY) {
        super.setCachedY(cachedY);
    }

    @Override
    public void shiftCached(long amount) {
        super.shiftCached(amount);
    }

    @Override
    public long extendHeight(RenderNode child, long heightOffset) {
        return this.extendHeightInRowMode(child, heightOffset);
    }

    @Override
    public void addChild(RenderNode child) {
        if (!this.isValid(child)) {
            TableCellRenderBox tsrb = new TableCellRenderBox();
            tsrb.addChild(child);
            this.addChild(tsrb);
            tsrb.close();
            return;
        }
        super.addChild(child);
    }

    private boolean isValid(RenderNode child) {
        if ((child.getNodeType() & 2) != 2) {
            return true;
        }
        if (child.getNodeType() == 524290) {
            return true;
        }
        if (child.getNodeType() == 294914) {
            return true;
        }
        if (child.getNodeType() == 530) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"WARN: BREAK MARKER INSIDE TABLE ROW");
            }
            return false;
        }
        if (child.getNodeType() == 0x1000012) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"WARN: PROGRESS MARKER INSIDE TABLE ROW");
            }
            return true;
        }
        return false;
    }

    @Override
    public RenderBox create(StyleSheet styleSheet) {
        return new AutoRenderBox(styleSheet);
    }
}

