/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilderWrapper;
import org.pentaho.reporting.engine.classic.core.layout.build.RenderNodeFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.SectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.style.SectionKeepTogetherStyleSheet;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class WatermarkLayoutModelBuilder
extends LayoutModelBuilderWrapper {
    private ArrayList<RenderNode> slots;
    private int slotCounter;
    private RenderBox parentBox;
    private int inBoxDepth;
    private OutputProcessorMetaData metaData;

    public WatermarkLayoutModelBuilder(LayoutModelBuilder backend) {
        super(backend);
        backend.setLimitedSubReports(true);
        backend.setCollapseProgressMarker(false);
        this.slots = new ArrayList();
    }

    @Override
    public void initialize(ProcessingContext metaData, RenderBox parentBox, RenderNodeFactory renderNodeFactory) {
        this.parentBox = parentBox;
        this.getParent().initialize(metaData, parentBox, new WatermarkRenderNodeFactory(renderNodeFactory));
        this.metaData = metaData.getOutputProcessorMetaData();
    }

    @Override
    public void setLimitedSubReports(boolean limitedSubReports) {
    }

    @Override
    public InstanceID startBox(ReportElement element) {
        InstanceID instanceID = this.getParent().startBox(element);
        ++this.inBoxDepth;
        return instanceID;
    }

    @Override
    public void startSection(ReportElement element, int sectionSize) {
        throw new UnsupportedOperationException("Global sections cannot be started for page headers");
    }

    @Override
    public InlineSubreportMarker processSubReport(SubReport element) {
        throw new UnsupportedOperationException("SubReports cannot be started for page headers");
    }

    @Override
    public boolean finishBox() {
        --this.inBoxDepth;
        if (this.inBoxDepth == 0) {
            ++this.slotCounter;
        }
        return super.finishBox();
    }

    @Override
    public void endSubFlow() {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void addProgressMarkerBox() {
        super.addProgressMarkerBox();
        ++this.slotCounter;
    }

    @Override
    public void addManualPageBreakBox(long range) {
        throw new UnsupportedOperationException("PageBreak sections cannot be started for page headers");
    }

    @Override
    public LayoutModelBuilder deriveForStorage(RenderBox clonedContent) {
        WatermarkLayoutModelBuilder clone = (WatermarkLayoutModelBuilder)super.deriveForStorage(clonedContent);
        clone.slots = (ArrayList)this.slots.clone();
        clone.slots.clear();
        clone.parentBox = clonedContent;
        return clone;
    }

    @Override
    public LayoutModelBuilder deriveForPageBreak() {
        WatermarkLayoutModelBuilder clone = (WatermarkLayoutModelBuilder)super.deriveForPageBreak();
        clone.slots = (ArrayList)this.slots.clone();
        clone.slots.clear();
        return clone;
    }

    @Override
    public void startSection() {
        this.slots.clear();
        this.slotCounter = 0;
        RenderNode lastChild = this.parentBox.getLastChild();
        if (lastChild instanceof RenderBox) {
            RenderBox slottedContent = (RenderBox)lastChild;
            for (RenderNode box = slottedContent.getLastChild(); box != null; box = box.getPrev()) {
                if (!box.getStyleSheet().getBooleanStyleProperty(BandStyleKeys.STICKY)) continue;
                this.slots.add(0, box);
            }
        }
        this.parentBox.clear();
        super.startSection();
    }

    @Override
    public void endSection() {
        if (this.metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY)) {
            super.legacyFlagNotEmpty();
        }
        super.endSection();
        for (int i = this.slotCounter; i < this.slots.size(); ++i) {
            RenderNode node = this.slots.get(i);
            this.parentBox.addGeneratedChild(node.derive(true));
        }
    }

    @Override
    public InstanceID createSubflowPlaceholder(ReportElement element) {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void startSubFlow(InstanceID insertationPoint) {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void startSubFlow(ReportElement element) {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void suspendSubFlow() {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    private static class WatermarkRenderNodeFactory
    implements RenderNodeFactory {
        private RenderNodeFactory backend;
        private BoxDefinition watermarkBoxDefinition;

        private WatermarkRenderNodeFactory(RenderNodeFactory backend) {
            BoxDefinition boxDefinition = new BoxDefinition();
            boxDefinition.setPreferredHeight(RenderLength.createPercentage(100.0));
            this.watermarkBoxDefinition = boxDefinition.lock();
            this.backend = backend;
        }

        @Override
        public LogicalPageBox createPage(ReportDefinition report, StyleSheet style) {
            return this.backend.createPage(report, style);
        }

        @Override
        public RenderBox produceSubReportPlaceholder(ReportElement element, StyleSheet style, ReportStateKey stateKey) {
            return this.backend.produceSubReportPlaceholder(element, style, stateKey);
        }

        @Override
        public RenderBox produceSectionBox(String layoutType, ReportStateKey stateKey) {
            SectionKeepTogetherStyleSheet styleSheet = new SectionKeepTogetherStyleSheet(false);
            return new SectionRenderBox(styleSheet, new InstanceID(), this.watermarkBoxDefinition, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.emptyMap(), stateKey);
        }

        @Override
        public RenderBox produceRenderBox(ReportElement band, StyleSheet style, String layoutType, ReportStateKey stateKey) {
            return this.backend.produceRenderBox(band, style, layoutType, stateKey);
        }

        @Override
        @Deprecated
        public RenderBox createAutoParagraph(ReportStateKey stateKey) {
            return this.backend.createAutoParagraph(stateKey);
        }

        @Override
        public RenderBox createAutoParagraph(ReportElement band, StyleSheet bandStyle, ReportStateKey stateKey) {
            return this.backend.createAutoParagraph(band, bandStyle, stateKey);
        }

        @Override
        public StyleSheet createAutoGeneratedSectionStyleSheet(StyleSheet style) {
            return this.backend.createAutoGeneratedSectionStyleSheet(style);
        }

        @Override
        public BoxDefinition getBoxDefinition(StyleSheet style) {
            return this.backend.getBoxDefinition(style);
        }

        @Override
        public RenderBox createPageBreakIndicatorBox(ReportStateKey stateKey, long range) {
            return this.backend.createPageBreakIndicatorBox(stateKey, range);
        }

        @Override
        public RenderableReplacedContentBox createReplacedContent(ReportElement element, StyleSheet style, Object value, Object rawValue, ReportStateKey stateKey) {
            return this.backend.createReplacedContent(element, style, value, rawValue, stateKey);
        }

        @Override
        public StyleSheet createStyle(StyleSheet style) {
            return this.backend.createStyle(style);
        }

        @Override
        public void close() {
            this.backend.close();
        }

        @Override
        public void initialize(OutputProcessorMetaData outputProcessorMetaData) {
            this.backend.initialize(outputProcessorMetaData);
        }
    }
}

