/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.dom;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.dom.AttributeMatcher;
import org.pentaho.reporting.engine.classic.core.dom.MatcherContext;
import org.pentaho.reporting.engine.classic.core.dom.NodeMatcher;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;

public class ElementMatcher
implements NodeMatcher {
    private String name;
    private ArrayList<AttributeMatcher> attributeMatchers;

    public ElementMatcher(ElementType name) {
        this(name.getMetaData().getName());
    }

    public ElementMatcher(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.attributeMatchers = new ArrayList();
        this.name = name;
    }

    public void add(AttributeMatcher matchers) {
        this.attributeMatchers.add(matchers);
    }

    @Override
    public boolean matches(MatcherContext context, ReportElement node) {
        if (node == null) {
            throw new NullPointerException();
        }
        String type = node.getElementType().getMetaData().getName();
        if (type.equals(this.name)) {
            return this.matchAttributes(context, node);
        }
        return false;
    }

    protected boolean matchAttributes(MatcherContext context, ReportElement node) {
        for (int i = 0; i < this.attributeMatchers.size(); ++i) {
            AttributeMatcher matcher = this.attributeMatchers.get(i);
            if (matcher.matches(context, node)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ElementMatcher(");
        stringBuilder.append(this.name);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

