/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.userroledao.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.engine.security.userroledao.UncategorizedUserRoleDaoException;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.security.userroledao.messages.Messages;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class UserRoleDaoUserDetailsService
implements UserDetailsService {
    private String rolePrefix = "ROLE_";
    private IUserRoleDao userRoleDao;
    private GrantedAuthority defaultRole;
    private String defaultRoleString;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        IPentahoUser user;
        boolean ACCOUNT_NON_EXPIRED = true;
        boolean CREDS_NON_EXPIRED = true;
        boolean ACCOUNT_NON_LOCKED = true;
        try {
            if (this.userRoleDao == null) {
                this.userRoleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
            }
            user = this.userRoleDao.getUser(null, username);
        }
        catch (UncategorizedUserRoleDaoException e) {
            throw new UserRoleDaoUserDetailsServiceException(Messages.getInstance().getString("UserRoleDaoUserDetailsService.ERROR_0003_DATA_ACCESS_EXCEPTION"), e);
        }
        if (user == null) {
            throw new UsernameNotFoundException(Messages.getInstance().getString("UserRoleDaoUserDetailsService.ERROR_0001_USER_NOT_FOUND"));
        }
        List userRoles = this.userRoleDao.getUserRoles(null, username);
        int authsSize = userRoles != null ? userRoles.size() : 0;
        GrantedAuthority[] auths = new GrantedAuthority[authsSize];
        int i = 0;
        for (IPentahoRole role : userRoles) {
            auths[i++] = new SimpleGrantedAuthority(role.getName());
        }
        ArrayList<GrantedAuthority> dbAuths = new ArrayList<GrantedAuthority>(Arrays.asList(auths));
        this.addCustomAuthorities(user.getUsername(), dbAuths);
        IPentahoSession session = PentahoSessionHolder.getSession();
        String tenantId = (String)session.getAttribute("org.pentaho.tenantId");
        if (tenantId == null) {
            ITenant tenant = JcrTenantUtils.getTenant(username, true);
            session.setAttribute("org.pentaho.tenantId", (Object)tenant.getId());
        }
        if (!StringUtils.isEmpty((String)this.defaultRoleString)) {
            this.defaultRole = new SimpleGrantedAuthority(this.defaultRoleString);
        }
        if (this.defaultRole != null && !dbAuths.contains(this.defaultRole)) {
            dbAuths.add(this.defaultRole);
        }
        if (dbAuths.size() == 0) {
            throw new UsernameNotFoundException(Messages.getInstance().getString("UserRoleDaoUserDetailsService.ERROR_0002_NO_AUTHORITIES"));
        }
        return new User(user.getUsername(), user.getPassword(), user.isEnabled(), true, true, true, dbAuths);
    }

    protected void addCustomAuthorities(String username, List authorities) {
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix == null ? "" : rolePrefix;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setUserRoleDao(IUserRoleDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole);
        this.defaultRoleString = defaultRole;
        this.defaultRole = new SimpleGrantedAuthority(defaultRole);
    }

    protected class UserRoleDaoUserDetailsServiceException
    extends DataAccessException {
        private static final long serialVersionUID = -3598806635515478946L;

        public UserRoleDaoUserDetailsServiceException(String msg) {
            super(msg);
        }

        public UserRoleDaoUserDetailsServiceException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

